/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.util;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.util.ExceptionUtils;

public final class ExtremeUtils {
    private static Log logger = LogFactory.getLog(ExtremeUtils.class);

    private ExtremeUtils() {
    }

    public static String camelCaseToWord(String camelCaseText) {
        if (StringUtils.isEmpty((String)camelCaseText)) {
            return camelCaseText;
        }
        if (camelCaseText.equals(camelCaseText.toUpperCase())) {
            return camelCaseText;
        }
        char[] ch = camelCaseText.toCharArray();
        String first = "" + ch[0];
        String build = first.toUpperCase();
        for (int i = 1; i < ch.length; ++i) {
            String test = "" + ch[i];
            if (test.equals(test.toUpperCase())) {
                build = build + " ";
            }
            build = build + test;
        }
        return build;
    }

    public static String formatDate(String parse, String format, Object value) {
        return ExtremeUtils.formatDate(parse, format, value, Locale.getDefault());
    }

    public static String formatDate(String parse, String format, Object value, Locale locale) {
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((String)format)) {
            String valueAsString = value.toString();
            logger.error((Object)("The format was not defined for date [" + valueAsString + "]."));
            return valueAsString;
        }
        Date date = null;
        if (value instanceof Date) {
            date = (Date)value;
        } else {
            String valueAsString = value.toString();
            if (StringUtils.isBlank((String)valueAsString)) {
                return valueAsString;
            }
            if (StringUtils.isBlank((String)parse)) {
                logger.error((Object)("The parse was not defined for date String [" + valueAsString + "]."));
                return valueAsString;
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(parse, locale);
                date = simpleDateFormat.parse(valueAsString);
            }
            catch (Exception e) {
                logger.error((Object)("The parse was incorrectly defined for date String [" + valueAsString + "]."));
                return valueAsString;
            }
        }
        return DateFormatUtils.format((Date)date, (String)format, (Locale)locale);
    }

    public static String formatNumber(String format, Object value) {
        return ExtremeUtils.formatNumber(format, value, Locale.getDefault());
    }

    public static String formatNumber(String format, Object value, Locale locale) {
        String result = null;
        if (value == null) {
            return result;
        }
        if (StringUtils.isBlank((String)format)) {
            logger.error((Object)("The format was not defined for number [" + value.toString() + "]."));
            return value.toString();
        }
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyLocalizedPattern(format);
        return df.format(Double.parseDouble(value.toString()));
    }

    public static Object retrieveFromScope(PageContext pageContext, String name) {
        return ExtremeUtils.retrieveFromScope(pageContext, name, null);
    }

    public static Object retrieveFromScope(PageContext pageContext, String name, String scope) {
        if (StringUtils.isBlank((String)scope)) {
            return pageContext.findAttribute(name);
        }
        int scopeType = 2;
        if (scope.equalsIgnoreCase("page")) {
            scopeType = 1;
        } else if (scope.equalsIgnoreCase("application")) {
            scopeType = 4;
        } else if (scope.equalsIgnoreCase("session")) {
            scopeType = 3;
        }
        return pageContext.getAttribute(name, scopeType);
    }

    public static int sessionSize(HttpSession session) {
        int total = 0;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            Enumeration enumeration = session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                Object obj = session.getAttribute(name);
                oos.writeObject(obj);
                int size = baos.size();
                total += size;
                logger.debug((Object)("The session name: " + name + " and the size is: " + size));
            }
            logger.debug((Object)("Total session size is: " + total));
        }
        catch (Exception e) {
            logger.error((Object)("Could not get the session size - " + ExceptionUtils.formatStackTrace(e)));
        }
        return total;
    }

    public static List beanProperties(Object bean) throws Exception {
        ArrayList properties = new ArrayList();
        if (bean instanceof Map) {
            properties.addAll(((Map)bean).keySet());
        } else {
            properties.addAll(BeanUtils.describe((Object)bean).keySet());
        }
        return properties;
    }

    public static boolean isBeanPropertyReadable(Object bean, String property) {
        boolean isReadable;
        if (bean instanceof Map) {
            return ((Map)bean).containsKey(property);
        }
        try {
            isReadable = PropertyUtils.isReadable((Object)bean, (String)property);
        }
        catch (IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not find the property [" + property + "]. Either the bean or property is null"));
            }
            isReadable = false;
        }
        return isReadable;
    }

    public static List checkboxesSelected(HttpServletRequest request, String startsWithValue) {
        ArrayList<String> results = new ArrayList<String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (!parameterName.startsWith(startsWithValue)) continue;
            results.add(StringUtils.substringAfter((String)parameterName, (String)startsWithValue));
        }
        return results;
    }

    public static String getQueryString(Map parameterMap) {
        Iterator iterator;
        StringBuffer results = new StringBuffer();
        Iterator iter = iterator = parameterMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String[] value = (String[])parameterMap.get(key);
            if (results.length() == 0) {
                results.append("?");
            } else {
                results.append("&");
            }
            results.append(key + "=");
            if (value == null || value.length <= 0) continue;
            results.append(value[0]);
        }
        return results.toString();
    }
}

