/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.core.TableConstants;
import org.extremecomponents.util.ExtremeUtils;

public class RetrievalUtils {
    private static Log logger = LogFactory.getLog(RetrievalUtils.class);

    public static Object retrieve(Context context, String name) {
        return RetrievalUtils.retrieve(context, name, null);
    }

    public static Object retrieve(Context context, String name, String scope) {
        ArrayList value;
        boolean convertArrayToMap;
        if (StringUtils.isNotBlank((String)scope)) {
            if (scope.equalsIgnoreCase(TableConstants.PAGE_SCOPE)) {
                return context.getPageAttribute(name);
            }
            if (scope.equalsIgnoreCase(TableConstants.REQUEST_SCOPE)) {
                return context.getRequestAttribute(name);
            }
            if (scope.equalsIgnoreCase(TableConstants.SESSION_SCOPE)) {
                return context.getSessionAttribute(name);
            }
            if (scope.equalsIgnoreCase(TableConstants.APPLICATION_SCOPE)) {
                return context.getApplicationAttribute(name);
            }
        }
        if (convertArrayToMap = name.startsWith("ListObjects_")) {
            name = name.substring(12);
        }
        if ((value = context.getPageAttribute(name)) == null) {
            value = context.getRequestAttribute(name);
        }
        if (value == null) {
            value = context.getSessionAttribute(name);
        }
        if (value == null) {
            value = context.getApplicationAttribute(name);
        }
        if (convertArrayToMap && value != null) {
            List formData = value;
            ArrayList newValue = new ArrayList();
            for (Object[] datas : formData) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                int dataS = datas.length;
                for (int i = 0; i < dataS; ++i) {
                    data.put("col" + i, datas[i]);
                }
                newValue.add(data);
            }
            value = newValue;
        }
        return value;
    }

    public static Collection retrieveCollection(Context context, Object collection) throws Exception {
        return RetrievalUtils.retrieveCollection(context, collection, null);
    }

    public static Collection retrieveCollection(Context context, Object collection, String scope) throws Exception {
        if (collection instanceof Collection) {
            return (Collection)collection;
        }
        if (collection instanceof Map) {
            return ((Map)collection).values();
        }
        if (collection instanceof String) {
            return RetrievalUtils.retrieveCollectionFromScope(context, String.valueOf(collection), scope);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Could not find the Collection.");
        }
        return Collections.EMPTY_LIST;
    }

    static Collection retrieveCollectionFromScope(Context context, String collection, String scope) throws Exception {
        Collection results = null;
        if (StringUtils.isBlank((String)collection) || "null".equals(collection)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"The collection is not defined.");
            }
            return Collections.EMPTY_LIST;
        }
        results = StringUtils.contains((String)collection, (String)".") ? RetrievalUtils.retrieveNestedCollection(context, collection, scope) : RetrievalUtils.retrieveCollectionAsObject(context, collection, scope);
        if (results == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Could not find the Collection.");
            }
            return Collections.EMPTY_LIST;
        }
        return results;
    }

    static Collection retrieveNestedCollection(Context context, String collection, String scope) throws Exception {
        String collectionToFind;
        String[] split = StringUtils.split((String)collection, (String)".");
        Object obj = RetrievalUtils.retrieve(context, split[0], scope);
        if (ExtremeUtils.isBeanPropertyReadable(obj, collectionToFind = StringUtils.substringAfter((String)collection, (String)"."))) {
            obj = obj instanceof Map ? ((Map)obj).get(collectionToFind) : PropertyUtils.getProperty((Object)obj, (String)collectionToFind);
        }
        if (!(obj instanceof Collection)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"The object is not of type Collection.");
            }
            return Collections.EMPTY_LIST;
        }
        return (Collection)obj;
    }

    static Collection retrieveCollectionAsObject(Context context, String collection, String scope) throws Exception {
        Object obj = RetrievalUtils.retrieve(context, collection, scope);
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof Map) {
            return ((Map)obj).values();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"The object is not of type Collection.");
        }
        return Collections.EMPTY_LIST;
    }
}

