/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.filter;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.context.Context;

public final class ExportFilterUtils {
    private static Log logger = LogFactory.getLog(ExportFilterUtils.class);

    private ExportFilterUtils() {
    }

    public static boolean isExported(Context context) {
        return StringUtils.isNotBlank((String)ExportFilterUtils.getTableId(context));
    }

    public static String getExportFileName(Context context) {
        String tableId = ExportFilterUtils.getTableId(context);
        if (StringUtils.isNotBlank((String)tableId)) {
            String exportFileNameStr = tableId + "_" + "efn";
            String exportFileName = context.getParameter(exportFileNameStr);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("eXtremeTable export file name [" + exportFileNameStr + "] is [" + exportFileName + "]"));
            }
            return exportFileName;
        }
        return null;
    }

    public static String getTableId(Context context) {
        return context.getParameter("ec_eti");
    }
}

