/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.limit;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.extremecomponents.table.limit.FilterSet;
import org.extremecomponents.table.limit.Limit;
import org.extremecomponents.table.limit.LimitFactory;
import org.extremecomponents.table.limit.Sort;

public final class TableLimit
implements Limit {
    protected LimitFactory limitFactory;
    protected FilterSet filterSet;
    protected Sort sort;
    protected boolean exported;
    protected int rowStart;
    protected int rowEnd;
    protected int currentRowsDisplayed;
    protected int page;
    protected int totalRows;
    protected boolean isSetPageNo;

    public TableLimit(LimitFactory limitFactory) {
        this.limitFactory = limitFactory;
        this.filterSet = limitFactory.getFilterSet();
        this.sort = limitFactory.getSort();
        this.page = limitFactory.getPage();
        this.exported = limitFactory.isExported();
        this.isSetPageNo = false;
    }

    public TableLimit(LimitFactory limitFactory, int nPageNo, int nPageSize) {
        this.limitFactory = limitFactory;
        this.filterSet = limitFactory.getFilterSet();
        this.sort = limitFactory.getSort();
        this.page = nPageNo;
        this.exported = limitFactory.isExported();
        this.currentRowsDisplayed = nPageSize;
        this.isSetPageNo = true;
    }

    public FilterSet getFilterSet() {
        return this.filterSet;
    }

    public int getRowEnd() {
        return this.rowEnd;
    }

    public int getRowStart() {
        return this.rowStart;
    }

    public Sort getSort() {
        return this.sort;
    }

    public int getPage() {
        return this.page;
    }

    public int getCurrentRowsDisplayed() {
        return this.currentRowsDisplayed;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public boolean isFiltered() {
        return this.filterSet.isFiltered();
    }

    public boolean isCleared() {
        return this.filterSet.isCleared();
    }

    public boolean isSorted() {
        return this.sort.isSorted();
    }

    public boolean isExported() {
        return this.exported;
    }

    public void setRowAttributes(int totalRows, int rowsDisplayed) {
        int crd = 15;
        crd = !this.isSetPageNo ? this.limitFactory.getCurrentRowsDisplayed(totalRows, rowsDisplayed) : this.currentRowsDisplayed;
        int page = this.getValidPage(this.page, totalRows, crd);
        int rowStart = (page - 1) * crd;
        int rowEnd = rowStart + crd;
        if (rowEnd > totalRows) {
            rowEnd = totalRows;
        }
        this.page = page;
        this.currentRowsDisplayed = crd;
        this.totalRows = totalRows;
        this.rowStart = rowStart;
        this.rowEnd = rowEnd;
    }

    private int getValidPage(int page, int totalRows, int currentRowsDisplayed) {
        if (!this.isValidPage(page, totalRows, currentRowsDisplayed)) {
            return this.getValidPage(--page, totalRows, currentRowsDisplayed);
        }
        return page;
    }

    private boolean isValidPage(int page, int totalRows, int currentRowsDisplayed) {
        if (page == 1) {
            return true;
        }
        int rowStart = (page - 1) * currentRowsDisplayed;
        int rowEnd = rowStart + currentRowsDisplayed;
        if (rowEnd > totalRows) {
            rowEnd = totalRows;
        }
        return rowEnd > rowStart;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("rowStart", this.rowStart);
        builder.append("rowEnd", this.rowEnd);
        builder.append("currentRowsDisplayed", this.currentRowsDisplayed);
        builder.append("page", this.page);
        builder.append("totalRows", this.totalRows);
        builder.append("exported", this.exported);
        builder.append("sort", (Object)this.sort);
        builder.append("filterSet", (Object)this.filterSet);
        return builder.toString();
    }
}

