/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.tree;

import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.cell.Cell;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.html.BuilderUtils;
import org.extremecomponents.table.view.html.CellBuilder;
import org.extremecomponents.tree.TreeModelUtils;
import org.extremecomponents.tree.TreeNode;
import org.extremecomponents.tree.TreeRegistryUtils;
import org.extremecomponents.util.HtmlBuilder;

public final class TreeCell
implements Cell {
    private static Log logger = LogFactory.getLog(TreeCell.class);
    public static final String PLUS_IMAGE = "plus";
    public static final String MINUS_IMAGE = "minus";

    public String getExportDisplay(TableModel model, Column column) {
        return null;
    }

    public String getHtmlDisplay(TableModel model, Column column) {
        HtmlBuilder html = new HtmlBuilder();
        CellBuilder.tdStart(html, column);
        String value = column.getValueAsString();
        if (StringUtils.isNotBlank((String)value)) {
            try {
                this.buildNodeCell(html, model, value);
            }
            catch (Exception e) {
                logger.error((Object)"TreeCell.html() Problem", (Throwable)e);
            }
        } else {
            html.nbsp();
        }
        CellBuilder.tdEnd(html);
        return html.toString();
    }

    private void buildNodeCell(HtmlBuilder html, TableModel model, String value) throws Exception {
        html.table(0).cellPadding("0").cellSpacing("0").border("0").close().tr(1).close();
        TreeNode node = (TreeNode)model.getCurrentRowBean();
        for (int i = 0; i < node.getDepth(); ++i) {
            html.td(2).width("16").close().nbsp().tdEnd();
        }
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            this.buildLink(html, model, node, value);
        } else {
            html.td(2).width("16").close().nbsp().tdEnd();
            html.td(2).align("left").close().append(value).tdEnd();
        }
        html.trEnd(1).tableEnd(0);
    }

    private void buildLink(HtmlBuilder html, TableModel model, TreeNode node, String value) throws Exception {
        html.td(2).width("16").close();
        html.a().quote();
        String action = model.getTableHandler().getTable().getAction();
        if (StringUtils.isNotEmpty((String)action)) {
            html.append(action);
        }
        html.append(action != null && action.indexOf(63) > 0 ? "&" : "?");
        html.append(this.getQueryString(node, model));
        html.quote();
        html.target(model.getTableHandler().getTable().getTarget());
        html.close();
        if (node.isOpen()) {
            html.img(BuilderUtils.getImage(model, MINUS_IMAGE));
        } else {
            html.img(BuilderUtils.getImage(model, PLUS_IMAGE));
        }
        html.aEnd();
        html.tdEnd().td(2).align("left").close().append(value).tdEnd();
    }

    private String getQueryString(TreeNode node, TableModel model) throws Exception {
        HtmlBuilder html = new HtmlBuilder();
        html.append(TreeRegistryUtils.getURLParameterString(model, true, true, false, false));
        String identifier = BeanUtils.getProperty((Object)node, (String)model.getTableHandler().getTable().getAttributeAsString("identifier"));
        String currentCellOpenKey = TreeModelUtils.getNodeKey(model, identifier);
        if (!node.isOpen()) {
            html.append("&amp;").append(currentCellOpenKey).equals().append("true");
        }
        Map openNodes = (Map)model.getTableHandler().getTable().getAttribute("openNodes");
        Object[] keys = openNodes.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].equals(currentCellOpenKey)) continue;
            html.append("&amp;").append(keys[i]).equals().append("true");
        }
        if (html.length() == 0) {
            return "";
        }
        return StringUtils.substringAfter((String)html.toString(), (String)"&amp;");
    }
}

