/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.TaskExport;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.cmmn.model.ProcessTask;

public class ProcessTaskExport
extends AbstractPlanItemDefinitionExport<ProcessTask> {
    @Override
    protected Class<ProcessTask> getExportablePlanItemDefinitionClass() {
        return ProcessTask.class;
    }

    @Override
    protected String getPlanItemDefinitionXmlElementValue(ProcessTask planItemDefinition) {
        return "processTask";
    }

    @Override
    protected void writePlanItemDefinitionSpecificAttributes(ProcessTask processTask, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionSpecificAttributes(processTask, xtw);
        TaskExport.writeCommonTaskAttributes(processTask, xtw);
    }

    @Override
    protected boolean writePlanItemDefinitionExtensionElements(CmmnModel model, ProcessTask processTask, boolean didWriteExtensionElement, XMLStreamWriter xtw) throws Exception {
        didWriteExtensionElement = this.writeIOParameters("in", processTask.getInParameters(), didWriteExtensionElement, xtw);
        didWriteExtensionElement = this.writeIOParameters("out", processTask.getOutParameters(), didWriteExtensionElement, xtw);
        return didWriteExtensionElement;
    }

    @Override
    protected void writePlanItemDefinitionBody(CmmnModel model, ProcessTask processTask, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionBody(model, processTask, xtw);
        if (StringUtils.isNotEmpty((CharSequence)processTask.getProcessRef()) || StringUtils.isNotEmpty((CharSequence)processTask.getProcessRefExpression())) {
            xtw.writeStartElement("processRefExpression");
            xtw.writeCData(StringUtils.isNotEmpty((CharSequence)processTask.getProcessRef()) ? processTask.getProcessRef() : processTask.getProcessRefExpression());
            xtw.writeEndElement();
        }
    }

    protected boolean writeIOParameters(String elementName, List<IOParameter> parameterList, boolean didWriteParameterStartElement, XMLStreamWriter xtw) throws Exception {
        if (parameterList == null || parameterList.isEmpty()) {
            return didWriteParameterStartElement;
        }
        for (IOParameter ioParameter : parameterList) {
            if (!didWriteParameterStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteParameterStartElement = true;
            }
            xtw.writeStartElement("flowable", elementName, "http://flowable.org/cmmn");
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSource())) {
                xtw.writeAttribute("source", ioParameter.getSource());
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                xtw.writeAttribute("sourceExpression", ioParameter.getSourceExpression());
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getTarget())) {
                xtw.writeAttribute("target", ioParameter.getTarget());
            }
            xtw.writeEndElement();
        }
        return didWriteParameterStartElement;
    }
}

