/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItemDefinition;

public class Stage
extends PlanFragment
implements HasExitCriteria {
    protected boolean isPlanModel;
    protected List<Criterion> exitCriteria = new ArrayList<Criterion>();
    protected boolean autoComplete;
    protected String autoCompleteCondition;
    protected String formKey;
    protected Integer displayOrder;
    protected Map<String, PlanItemDefinition> planItemDefinitionMap = new LinkedHashMap<String, PlanItemDefinition>();

    public void addPlanItemDefinition(PlanItemDefinition planItemDefinition) {
        this.planItemDefinitionMap.put(planItemDefinition.getId(), planItemDefinition);
    }

    public PlanItemDefinition findPlanItemDefinition(String planItemDefinitionId) {
        if (this.id != null && this.id.equals(planItemDefinitionId)) {
            return this;
        }
        if (this.planItemDefinitionMap.containsKey(planItemDefinitionId)) {
            return this.planItemDefinitionMap.get(planItemDefinitionId);
        }
        Stage parentStage = this.getParentStage();
        if (parentStage != null) {
            return parentStage.findPlanItemDefinition(planItemDefinitionId);
        }
        return null;
    }

    public <T extends PlanItemDefinition> List<T> findPlanItemDefinitionsOfType(Class<T> clazz, boolean recursive) {
        ArrayList planItemDefinitions = new ArrayList();
        this.internalFindPlanItemDefinitionsOfType(clazz, this, planItemDefinitions, recursive);
        return planItemDefinitions;
    }

    private <T extends PlanItemDefinition> void internalFindPlanItemDefinitionsOfType(Class<T> clazz, Stage stage, List<T> planItemDefinitions, boolean recursive) {
        for (PlanItemDefinition planItemDefinition : stage.getPlanItemDefinitions()) {
            if (clazz.isInstance(planItemDefinition)) {
                planItemDefinitions.add(planItemDefinition);
            }
            if (!recursive || !(planItemDefinition instanceof Stage)) continue;
            this.internalFindPlanItemDefinitionsOfType(clazz, (Stage)planItemDefinition, planItemDefinitions, recursive);
        }
    }

    public List<PlanItemDefinition> getPlanItemDefinitions() {
        return new ArrayList<PlanItemDefinition>(this.planItemDefinitionMap.values());
    }

    public Map<String, PlanItemDefinition> getPlanItemDefinitionMap() {
        return this.planItemDefinitionMap;
    }

    public void setPlanItemDefinitionMap(Map<String, PlanItemDefinition> planItemDefinitionMap) {
        this.planItemDefinitionMap = planItemDefinitionMap;
    }

    public boolean isPlanModel() {
        return this.isPlanModel;
    }

    public void setPlanModel(boolean isPlanModel) {
        this.isPlanModel = isPlanModel;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
    }

    public String getAutoCompleteCondition() {
        return this.autoCompleteCondition;
    }

    public void setAutoCompleteCondition(String autoCompleteCondition) {
        this.autoCompleteCondition = autoCompleteCondition;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    @Override
    public void addExitCriterion(Criterion exitCriterion) {
        this.exitCriteria.add(exitCriterion);
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Override
    public List<Criterion> getExitCriteria() {
        return this.exitCriteria;
    }

    @Override
    public void setExitCriteria(List<Criterion> exitCriteria) {
        this.exitCriteria = exitCriteria;
    }
}

