/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class CallActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    private static final long serialVersionUID = 1L;
    public static final String CALLED_ELEMENT_TYPE_KEY = "key";
    public static final String CALLED_ELEMENT_TYPE_ID = "id";
    protected String calledElement;
    protected String calledElementType;
    protected Expression calledElementExpression;
    protected List<MapExceptionEntry> mapExceptions;

    public CallActivityBehavior(String processDefinitionKey, String calledElementType, List<MapExceptionEntry> mapExceptions) {
        this.calledElement = processDefinitionKey;
        this.calledElementType = calledElementType;
        this.mapExceptions = mapExceptions;
    }

    public CallActivityBehavior(Expression processDefinitionExpression, String calledElementType, List<MapExceptionEntry> mapExceptions) {
        this.calledElementExpression = processDefinitionExpression;
        this.calledElementType = calledElementType;
        this.mapExceptions = mapExceptions;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CallActivity callActivity = (CallActivity)executionEntity.getCurrentFlowElement();
        ProcessDefinition processDefinition = this.getProcessDefinition(execution, callActivity);
        Process subProcess = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        if (subProcess == null) {
            throw new FlowableException("Cannot start a sub process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = subProcess.getInitialFlowElement();
        if (initialFlowElement == null) {
            throw new FlowableException("No start element found for process definition " + processDefinition.getId());
        }
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new FlowableException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        String businessKey = null;
        if (!StringUtils.isEmpty((CharSequence)callActivity.getBusinessKey())) {
            Expression expression = expressionManager.createExpression(callActivity.getBusinessKey());
            businessKey = expression.getValue((VariableContainer)execution).toString();
        } else if (callActivity.isInheritBusinessKey()) {
            ExecutionEntity processInstance = (ExecutionEntity)executionEntityManager.findById(execution.getProcessInstanceId());
            businessKey = processInstance.getBusinessKey();
        }
        ExecutionEntity subProcessInstance = CommandContextUtil.getExecutionEntityManager(commandContext).createSubprocessInstance(processDefinition, executionEntity, businessKey, initialFlowElement.getId());
        CommandContextUtil.getHistoryManager(commandContext).recordSubProcessInstanceStart(executionEntity, subProcessInstance);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_CREATED, subProcessInstance));
        }
        subProcessInstance.setVariables(this.processDataObjects(subProcess.getDataObjects()));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (callActivity.isInheritVariables()) {
            Map executionVariables = execution.getVariables();
            for (Map.Entry entry : executionVariables.entrySet()) {
                variables.put((String)entry.getKey(), entry.getValue());
            }
        }
        for (IOParameter ioParameter : callActivity.getInParameters()) {
            Object value = null;
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(ioParameter.getSourceExpression().trim());
                value = expression.getValue((VariableContainer)execution);
            } else {
                value = execution.getVariable(ioParameter.getSource());
            }
            variables.put(ioParameter.getTarget(), value);
        }
        if (!variables.isEmpty()) {
            this.initializeVariables(subProcessInstance, variables);
        }
        String processInstanceName = null;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getProcessInstanceName())) {
            Expression processInstanceNameExpression = expressionManager.createExpression(callActivity.getProcessInstanceName());
            processInstanceName = processInstanceNameExpression.getValue((VariableContainer)subProcessInstance).toString();
            subProcessInstance.setName(processInstanceName);
        }
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, subProcessInstance));
        }
        ExecutionEntity subProcessInitialExecution = executionEntityManager.createChildExecution(subProcessInstance);
        subProcessInitialExecution.setCurrentFlowElement(initialFlowElement);
        CommandContextUtil.getAgenda().planContinueProcessOperation(subProcessInitialExecution);
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createProcessStartedEvent(subProcessInitialExecution, variables, false));
        }
    }

    private ProcessDefinition getProcessDefinition(DelegateExecution execution, CallActivity callActivity) {
        ProcessDefinition processDefinition;
        switch (StringUtils.isNotEmpty((CharSequence)this.calledElementType) ? this.calledElementType : CALLED_ELEMENT_TYPE_KEY) {
            case "id": {
                processDefinition = this.getProcessDefinitionById(execution);
                break;
            }
            case "key": {
                processDefinition = this.getProcessDefinitionByKey(execution, callActivity.isSameDeployment());
                break;
            }
            default: {
                throw new FlowableException("Unrecognized calledElementType [" + this.calledElementType + "]");
            }
        }
        return processDefinition;
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CallActivity callActivity = (CallActivity)executionEntity.getCurrentFlowElement();
        for (IOParameter ioParameter : callActivity.getOutParameters()) {
            Object value = null;
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(ioParameter.getSourceExpression().trim());
                value = expression.getValue((VariableContainer)subProcessInstance);
            } else {
                value = subProcessInstance.getVariable(ioParameter.getSource());
            }
            if (callActivity.isUseLocalScopeForOutParameters()) {
                execution.setVariableLocal(ioParameter.getTarget(), value);
                continue;
            }
            execution.setVariable(ioParameter.getTarget(), value);
        }
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
        this.leave(execution);
    }

    protected ProcessDefinition getProcessDefinitionById(DelegateExecution execution) {
        return CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.getCalledElementValue(execution));
    }

    protected ProcessDefinition getProcessDefinitionByKey(DelegateExecution execution, boolean isSameDeployment) {
        return this.findProcessDefinitionByKey(this.getCalledElementValue(execution), execution.getProcessDefinitionId(), execution.getTenantId(), isSameDeployment);
    }

    protected String getCalledElementValue(DelegateExecution execution) {
        String calledElementValue = this.calledElementExpression != null ? (String)this.calledElementExpression.getValue((VariableContainer)execution) : this.calledElement;
        return calledElementValue;
    }

    protected ProcessDefinition findProcessDefinitionByKey(String processDefinitionKey, String processDefinitionId, String tenantId, boolean sameDeployment) {
        if (sameDeployment) {
            String deploymentId = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId).getDeploymentId();
            ProcessDefinitionEntityManager processDefinitionEntityManager = Context.getProcessEngineConfiguration().getProcessDefinitionEntityManager();
            ProcessDefinitionEntity processDefinitionByDeploymentAndKey = null;
            processDefinitionByDeploymentAndKey = tenantId == null || "".equals(tenantId) ? processDefinitionEntityManager.findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey) : processDefinitionEntityManager.findProcessDefinitionByDeploymentAndKeyAndTenantId(deploymentId, processDefinitionKey, tenantId);
            if (processDefinitionByDeploymentAndKey != null) {
                return processDefinitionByDeploymentAndKey;
            }
        }
        if (tenantId == null || "".equals(tenantId)) {
            return CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKey(processDefinitionKey);
        }
        return CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            variablesMap = new HashMap(dataObjects.size());
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    protected void initializeVariables(ExecutionEntity subProcessInstance, Map<String, Object> variables) {
        subProcessInstance.setVariables(variables);
    }

    public void setCalledElement(String calledElement) {
        this.calledElement = calledElement;
    }

    public String getCalledElement() {
        return this.calledElement;
    }
}

