/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.history.HistoricVariableInstance;

public class GetTaskFormModelCmd
implements Command<FormInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected boolean ignoreVariables;

    public GetTaskFormModelCmd(String taskId, boolean ignoreVariables) {
        this.taskId = taskId;
        this.ignoreVariables = ignoreVariables;
    }

    public FormInfo execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        FormService formService = CommandContextUtil.getFormService();
        if (formService == null) {
            throw new FlowableIllegalArgumentException("Form engine is not initialized");
        }
        TaskEntity task = CommandContextUtil.getTaskService().getTask(this.taskId);
        Date endTime = null;
        if (task == null && (task = CommandContextUtil.getHistoricTaskService().getHistoricTask(this.taskId)) != null) {
            endTime = ((HistoricTaskInstance)task).getEndTime();
        }
        if (task == null) {
            throw new FlowableObjectNotFoundException("Task not found with id " + this.taskId);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (!this.ignoreVariables && task.getProcessInstanceId() != null) {
            List variableInstances = processEngineConfiguration.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(task.getProcessInstanceId()).list();
            for (HistoricVariableInstance historicVariableInstance : variableInstances) {
                variables.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
            }
        }
        String parentDeploymentId = null;
        if (StringUtils.isNotEmpty((CharSequence)task.getProcessDefinitionId())) {
            RepositoryService repositoryService = processEngineConfiguration.getRepositoryService();
            ProcessDefinition processDefinition = repositoryService.getProcessDefinition(task.getProcessDefinitionId());
            Deployment deployment = (Deployment)repositoryService.createDeploymentQuery().deploymentId(processDefinition.getDeploymentId()).singleResult();
            parentDeploymentId = deployment.getParentDeploymentId();
        }
        FormInfo formInfo = null;
        if (this.ignoreVariables) {
            FormRepositoryService formRepositoryService = CommandContextUtil.getFormRepositoryService();
            formInfo = formRepositoryService.getFormModelByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId);
            if (formInfo == null && parentDeploymentId != null) {
                formInfo = formRepositoryService.getFormModelByKey(task.getFormKey());
            }
        } else if (endTime != null) {
            formInfo = formService.getFormInstanceModelByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, this.taskId, task.getProcessInstanceId(), variables, task.getTenantId());
            if (formInfo == null && parentDeploymentId != null) {
                formInfo = formService.getFormInstanceModelByKey(task.getFormKey(), this.taskId, task.getProcessInstanceId(), variables, task.getTenantId());
            }
        } else {
            formInfo = formService.getFormModelWithVariablesByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, this.taskId, variables, task.getTenantId());
            if (formInfo == null && parentDeploymentId != null) {
                formInfo = formService.getFormModelWithVariablesByKey(task.getFormKey(), this.taskId, variables, task.getTenantId());
            }
        }
        if (formInfo == null) {
            throw new FlowableObjectNotFoundException("Form model for task " + task.getTaskDefinitionKey() + " cannot be found for form key " + task.getFormKey());
        }
        FormFieldHandler formFieldHandler = CommandContextUtil.getProcessEngineConfiguration(commandContext).getFormFieldHandler();
        formFieldHandler.enrichFormFields(formInfo);
        return formInfo;
    }
}

