/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;

public class ProcessInstanceMigrationDocumentImpl
implements ProcessInstanceMigrationDocument {
    protected String migrateToProcessDefinitionId;
    protected String migrateToProcessDefinitionKey;
    protected int migrateToProcessDefinitionVersion;
    protected String migrateToProcessDefinitionTenantId;
    protected Map<String, String> activityMigrationMappings;

    public static ProcessInstanceMigrationDocument fromProcessInstanceMigrationDocumentJson(String processInstanceMigrationDocumentJson) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (ProcessInstanceMigrationDocument)objectMapper.readValue(processInstanceMigrationDocumentJson, ProcessInstanceMigrationDocumentImpl.class);
        }
        catch (IOException e) {
            throw new FlowableIllegalArgumentException("Low level I/O problem with Json argument", (Throwable)e);
        }
    }

    public void setMigrateToProcessDefinitionId(String processDefinitionId) {
        this.migrateToProcessDefinitionId = processDefinitionId;
    }

    @Override
    public String getMigrateToProcessDefinitionId() {
        return this.migrateToProcessDefinitionId;
    }

    public void setMigrateToProcessDefinition(String processDefinitionKey, int processDefinitionVersion) {
        this.migrateToProcessDefinitionKey = processDefinitionKey;
        this.migrateToProcessDefinitionVersion = processDefinitionVersion;
    }

    public void setMigrateToProcessDefinition(String processDefinitionKey, int processDefinitionVersion, String processDefinitionTenantId) {
        this.migrateToProcessDefinitionKey = processDefinitionKey;
        this.migrateToProcessDefinitionVersion = processDefinitionVersion;
        this.migrateToProcessDefinitionTenantId = processDefinitionTenantId;
    }

    @Override
    public String getMigrateToProcessDefinitionKey() {
        return this.migrateToProcessDefinitionKey;
    }

    @Override
    public int getMigrateToProcessDefinitionVersion() {
        return this.migrateToProcessDefinitionVersion;
    }

    @Override
    public String getMigrateToProcessDefinitionTenantId() {
        return this.migrateToProcessDefinitionTenantId;
    }

    public void setActivityMigrationMappings(Map<String, String> activityMigrationMappings) {
        this.activityMigrationMappings = activityMigrationMappings;
    }

    @Override
    public Map<String, String> getActivityMigrationMappings() {
        return this.activityMigrationMappings;
    }

    @Override
    public String asJsonString() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "ProcessInstanceMigrationDocumentImpl{migrateToProcessDefinitionId='" + this.migrateToProcessDefinitionId + '\'' + ", migrateToProcessDefinitionKey='" + this.migrateToProcessDefinitionKey + '\'' + ", migrateToProcessDefinitionVersion='" + this.migrateToProcessDefinitionVersion + '\'' + ", migrateToProcessDefinitionTenantId='" + this.migrateToProcessDefinitionTenantId + '\'' + ", activityMigrationMappings=" + this.activityMigrationMappings + '}';
    }
}

