/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.listener;

import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.delegate.invocation.TaskListenerInvocation;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.service.delegate.DelegateTask;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionTaskListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    public void notify(DelegateTask delegateTask) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableContainer)delegateTask, this.fieldDeclarations);
        if (delegate instanceof TaskListener) {
            try {
                CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)delegate, delegateTask));
            }
            catch (Exception e) {
                throw new FlowableException("Exception while invoking TaskListener: " + e.getMessage(), (Throwable)e);
            }
        } else {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + TaskListener.class);
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

