/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationExecutor;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.FlywaySqlScriptException;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.flywaydb.core.internal.metadatatable.AppliedMigration;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.TimeFormat;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class DbMigrate {
    private static final Log LOG = LogFactory.getLog(DbMigrate.class);
    private final DbSupport dbSupport;
    private final MetaDataTable metaDataTable;
    private final Schema schema;
    private final MigrationResolver migrationResolver;
    private final FlywayConfiguration configuration;
    private final Connection connectionUserObjects;
    private final boolean ignoreFailedFutureMigration;
    private final DbSupport dbSupportUserObjects;

    public DbMigrate(Connection connectionUserObjects, DbSupport dbSupport, MetaDataTable metaDataTable, Schema schema, MigrationResolver migrationResolver, boolean ignoreFailedFutureMigration, FlywayConfiguration configuration) {
        this.connectionUserObjects = connectionUserObjects;
        this.dbSupport = dbSupport;
        this.metaDataTable = metaDataTable;
        this.schema = schema;
        this.migrationResolver = migrationResolver;
        this.ignoreFailedFutureMigration = ignoreFailedFutureMigration;
        this.configuration = configuration;
        this.dbSupportUserObjects = DbSupportFactory.createDbSupport(connectionUserObjects, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int migrate() throws FlywayException {
        try {
            boolean firstRun;
            int count;
            for (final FlywayCallback callback : this.configuration.getCallbacks()) {
                new TransactionTemplate(this.connectionUserObjects).execute(new Callable<Object>(){

                    @Override
                    public Object call() throws SQLException {
                        DbMigrate.this.dbSupportUserObjects.changeCurrentSchemaTo(DbMigrate.this.schema);
                        callback.beforeMigrate(DbMigrate.this.connectionUserObjects);
                        return null;
                    }
                });
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            int migrationSuccessCount = 0;
            while ((count = this.metaDataTable.lock(new Callable<Integer>(firstRun = migrationSuccessCount == 0){
                final /* synthetic */ boolean val$firstRun;
                {
                    this.val$firstRun = bl;
                }

                @Override
                public Integer call() {
                    MigrationInfo[] failed;
                    MigrationInfo[] future;
                    MigrationInfoServiceImpl infoService = new MigrationInfoServiceImpl(DbMigrate.this.migrationResolver, DbMigrate.this.metaDataTable, DbMigrate.this.configuration.getTarget(), DbMigrate.this.configuration.isOutOfOrder(), true, true, true);
                    infoService.refresh();
                    MigrationVersion currentSchemaVersion = MigrationVersion.EMPTY;
                    if (infoService.current() != null) {
                        currentSchemaVersion = infoService.current().getVersion();
                    }
                    if (this.val$firstRun) {
                        LOG.info("Current version of schema " + DbMigrate.this.schema + ": " + currentSchemaVersion);
                        if (DbMigrate.this.configuration.isOutOfOrder()) {
                            LOG.warn("outOfOrder mode is active. Migration of schema " + DbMigrate.this.schema + " may not be reproducible.");
                        }
                    }
                    if ((future = infoService.future()).length > 0) {
                        MigrationInfo[] resolved = infoService.resolved();
                        if (resolved.length == 0) {
                            LOG.warn("Schema " + DbMigrate.this.schema + " has version " + currentSchemaVersion + ", but no migration could be resolved in the configured locations !");
                        } else {
                            int offset = resolved.length - 1;
                            while (resolved[offset].getVersion() == null) {
                                --offset;
                            }
                            LOG.warn("Schema " + DbMigrate.this.schema + " has a version (" + currentSchemaVersion + ") that is newer than the latest available migration (" + resolved[offset].getVersion() + ") !");
                        }
                    }
                    if ((failed = infoService.failed()).length > 0) {
                        if (failed.length == 1 && failed[0].getState() == MigrationState.FUTURE_FAILED && (DbMigrate.this.configuration.isIgnoreFutureMigrations() || DbMigrate.this.ignoreFailedFutureMigration)) {
                            LOG.warn("Schema " + DbMigrate.this.schema + " contains a failed future migration to version " + failed[0].getVersion() + " !");
                        } else {
                            if (failed[0].getVersion() == null) {
                                throw new FlywayException("Schema " + DbMigrate.this.schema + " contains a failed repeatable migration (" + failed[0].getDescription() + ") !");
                            }
                            throw new FlywayException("Schema " + DbMigrate.this.schema + " contains a failed migration to version " + failed[0].getVersion() + " !");
                        }
                    }
                    LinkedHashMap<MigrationInfoImpl, Boolean> group = new LinkedHashMap<MigrationInfoImpl, Boolean>();
                    for (MigrationInfoImpl pendingMigration : infoService.pending()) {
                        boolean isOutOfOrder = pendingMigration.getVersion() != null && pendingMigration.getVersion().compareTo(currentSchemaVersion) < 0;
                        group.put(pendingMigration, isOutOfOrder);
                        if (!DbMigrate.this.configuration.isGroup()) break;
                    }
                    if (!group.isEmpty()) {
                        DbMigrate.this.applyMigrations(group);
                    }
                    return group.size();
                }
            }).intValue()) != 0) {
                migrationSuccessCount += count;
            }
            stopWatch.stop();
            this.logSummary(migrationSuccessCount, stopWatch.getTotalTimeMillis());
            for (final FlywayCallback callback : this.configuration.getCallbacks()) {
                new TransactionTemplate(this.connectionUserObjects).execute(new Callable<Object>(){

                    @Override
                    public Object call() throws SQLException {
                        DbMigrate.this.dbSupportUserObjects.changeCurrentSchemaTo(DbMigrate.this.schema);
                        callback.afterMigrate(DbMigrate.this.connectionUserObjects);
                        return null;
                    }
                });
            }
            int n = migrationSuccessCount;
            return n;
        }
        finally {
            this.dbSupportUserObjects.restoreCurrentSchema();
        }
    }

    private void logSummary(int migrationSuccessCount, long executionTime) {
        if (migrationSuccessCount == 0) {
            LOG.info("Schema " + this.schema + " is up to date. No migration necessary.");
            return;
        }
        if (migrationSuccessCount == 1) {
            LOG.info("Successfully applied 1 migration to schema " + this.schema + " (execution time " + TimeFormat.format(executionTime) + ").");
        } else {
            LOG.info("Successfully applied " + migrationSuccessCount + " migrations to schema " + this.schema + " (execution time " + TimeFormat.format(executionTime) + ").");
        }
    }

    private void applyMigrations(final LinkedHashMap<MigrationInfoImpl, Boolean> group) {
        boolean executeGroupInTransaction = this.isExecuteGroupInTransaction(group);
        final StopWatch stopWatch = new StopWatch();
        try {
            if (executeGroupInTransaction) {
                new TransactionTemplate(this.connectionUserObjects).execute(new Callable<Object>(){

                    @Override
                    public Object call() throws SQLException {
                        DbMigrate.this.doMigrateGroup(group, stopWatch);
                        return null;
                    }
                });
            } else {
                this.doMigrateGroup(group, stopWatch);
            }
        }
        catch (FlywayMigrateSqlException e) {
            MigrationInfoImpl migration = e.getMigration();
            String failedMsg = "Migration of " + this.toMigrationText(migration, e.isOutOfOrder()) + " failed!";
            if (this.dbSupport.supportsDdlTransactions() && executeGroupInTransaction) {
                LOG.error(failedMsg + " Changes successfully rolled back.");
            } else {
                LOG.error(failedMsg + " Please restore backups and roll back database and code!");
                stopWatch.stop();
                int executionTime = (int)stopWatch.getTotalTimeMillis();
                AppliedMigration appliedMigration = new AppliedMigration(migration.getVersion(), migration.getDescription(), migration.getType(), migration.getScript(), migration.getResolvedMigration().getChecksum(), executionTime, false);
                this.metaDataTable.addAppliedMigration(appliedMigration);
            }
            throw e;
        }
    }

    private boolean isExecuteGroupInTransaction(LinkedHashMap<MigrationInfoImpl, Boolean> group) {
        boolean executeGroupInTransaction = true;
        boolean first = true;
        for (Map.Entry<MigrationInfoImpl, Boolean> entry : group.entrySet()) {
            ResolvedMigration resolvedMigration = entry.getKey().getResolvedMigration();
            boolean inTransaction = resolvedMigration.getExecutor().executeInTransaction();
            if (first) {
                executeGroupInTransaction = inTransaction;
                first = false;
                continue;
            }
            if (!this.configuration.isMixed() && executeGroupInTransaction != inTransaction) {
                throw new FlywayException("Detected both transactional and non-transactional migrations within the same migration group (even though mixed is false). First offending migration:" + (resolvedMigration.getVersion() == null ? "" : " " + resolvedMigration.getVersion()) + (StringUtils.hasLength(resolvedMigration.getDescription()) ? " " + resolvedMigration.getDescription() : "") + (inTransaction ? "" : " [non-transactional]"));
            }
            executeGroupInTransaction = executeGroupInTransaction && inTransaction;
        }
        return executeGroupInTransaction;
    }

    private void doMigrateGroup(LinkedHashMap<MigrationInfoImpl, Boolean> group, StopWatch stopWatch) {
        for (Map.Entry<MigrationInfoImpl, Boolean> entry : group.entrySet()) {
            MigrationInfoImpl migration = entry.getKey();
            boolean isOutOfOrder = entry.getValue();
            String migrationText = this.toMigrationText(migration, isOutOfOrder);
            stopWatch.start();
            LOG.info("Migrating " + migrationText);
            this.dbSupportUserObjects.changeCurrentSchemaTo(this.schema);
            for (FlywayCallback callback : this.configuration.getCallbacks()) {
                callback.beforeEachMigrate(this.connectionUserObjects, migration);
            }
            try {
                migration.getResolvedMigration().getExecutor().execute(this.connectionUserObjects);
            }
            catch (FlywaySqlScriptException e) {
                throw new FlywayMigrateSqlException(migration, isOutOfOrder, e);
            }
            catch (SQLException e) {
                throw new FlywayMigrateSqlException(migration, isOutOfOrder, e);
            }
            LOG.debug("Successfully completed migration of " + migrationText);
            for (FlywayCallback callback : this.configuration.getCallbacks()) {
                callback.afterEachMigrate(this.connectionUserObjects, migration);
            }
            stopWatch.stop();
            int executionTime = (int)stopWatch.getTotalTimeMillis();
            AppliedMigration appliedMigration = new AppliedMigration(migration.getVersion(), migration.getDescription(), migration.getType(), migration.getScript(), migration.getResolvedMigration().getChecksum(), executionTime, true);
            this.metaDataTable.addAppliedMigration(appliedMigration);
        }
    }

    private String toMigrationText(MigrationInfoImpl migration, boolean isOutOfOrder) {
        MigrationExecutor migrationExecutor = migration.getResolvedMigration().getExecutor();
        String migrationText = migration.getVersion() != null ? "schema " + this.schema + " to version " + migration.getVersion() + " - " + migration.getDescription() + (isOutOfOrder ? " [out of order]" : "") + (migrationExecutor.executeInTransaction() ? "" : " [non-transactional]") : "schema " + this.schema + " with repeatable migration " + migration.getDescription() + (migrationExecutor.executeInTransaction() ? "" : " [non-transactional]");
        return migrationText;
    }

    public static class FlywayMigrateSqlException
    extends FlywaySqlScriptException {
        private final MigrationInfoImpl migration;
        private final boolean outOfOrder;

        FlywayMigrateSqlException(MigrationInfoImpl migration, boolean outOfOrder, SQLException e) {
            super(null, null, e);
            this.migration = migration;
            this.outOfOrder = outOfOrder;
        }

        FlywayMigrateSqlException(MigrationInfoImpl migration, boolean outOfOrder, FlywaySqlScriptException e) {
            super(e.getResource(), e.getSqlStatement(), (SQLException)e.getCause());
            this.migration = migration;
            this.outOfOrder = outOfOrder;
        }

        public MigrationInfoImpl getMigration() {
            return this.migration;
        }

        public boolean isOutOfOrder() {
            return this.outOfOrder;
        }
    }
}

