/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.postgresql;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.dbsupport.FlywaySqlException;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class PostgreSQLAdvisoryLockTemplate {
    private static final Log LOG = LogFactory.getLog(PostgreSQLAdvisoryLockTemplate.class);
    private static final long LOCK_MAGIC_NUM = 77431708279161L;
    private final JdbcTemplate jdbcTemplate;
    private final long lockNum;

    PostgreSQLAdvisoryLockTemplate(JdbcTemplate jdbcTemplate, int discriminator) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockNum = 77431708279161L + (long)discriminator;
    }

    public <T> T execute(Callable<T> callable) {
        try {
            this.jdbcTemplate.execute("SELECT pg_advisory_lock(" + this.lockNum + ")", new Object[0]);
            T t = callable.call();
            return t;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to acquire Flyway advisory lock", e);
        }
        catch (Exception e) {
            RuntimeException rethrow = e instanceof RuntimeException ? (RuntimeException)e : new FlywayException(e);
            throw rethrow;
        }
        finally {
            try {
                this.jdbcTemplate.execute("SELECT pg_advisory_unlock(" + this.lockNum + ")", new Object[0]);
            }
            catch (SQLException e) {
                LOG.error("Unable to release Flyway advisory lock", e);
            }
        }
    }
}

