/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.errorhandler.Context;
import org.flywaydb.core.api.errorhandler.Warning;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.Delimiter;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.sqlscript.FlywaySqlScriptException;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.jdbc.ContextImpl;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.jdbc.Result;
import org.flywaydb.core.internal.util.scanner.LoadableResource;
import org.flywaydb.core.internal.util.scanner.Resource;

public class SqlScript {
    private static final Log LOG = LogFactory.getLog(SqlScript.class);
    private final Database<?> database;
    private final boolean mixed;
    private final List<SqlStatement> sqlStatements;
    private final Resource resource;
    private boolean transactionalStatementFound;
    private boolean nonTransactionalStatementFound;

    public SqlScript(String sqlScriptSource, Database database) {
        this.database = database;
        this.mixed = false;
        this.sqlStatements = this.parse(sqlScriptSource);
        this.resource = null;
    }

    public SqlScript(Database database, LoadableResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, String encoding, boolean mixed) {
        this.database = database;
        this.resource = sqlScriptResource;
        this.mixed = mixed;
        String sqlScriptSource = sqlScriptResource.loadAsString(encoding);
        this.sqlStatements = this.parse(placeholderReplacer.replacePlaceholders(sqlScriptSource));
    }

    public boolean executeInTransaction() {
        return !this.nonTransactionalStatementFound;
    }

    public List<SqlStatement> getSqlStatements() {
        return this.sqlStatements;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void execute(JdbcTemplate jdbcTemplate) {
        for (SqlStatement sqlStatement : this.sqlStatements) {
            ContextImpl context = new ContextImpl();
            String sql = sqlStatement.getSql();
            LOG.debug("Executing SQL: " + sql);
            try {
                List<Result> results = sqlStatement.execute(context, jdbcTemplate);
                this.printWarnings(context);
                for (Result result : results) {
                    if (result.getUpdateCount() == -1L) continue;
                    LOG.debug("Update Count: " + result.getUpdateCount());
                }
            }
            catch (SQLException e) {
                this.printWarnings(context);
                throw new FlywaySqlScriptException(this.resource, sqlStatement, e);
            }
        }
    }

    private void printWarnings(Context context) {
        for (Warning warning : context.getWarnings()) {
            if ("00000".equals(warning.getState())) {
                LOG.info("DB: " + warning.getMessage());
                continue;
            }
            LOG.warn("DB: " + warning.getMessage() + " (SQL State: " + warning.getState() + " - Error Code: " + warning.getCode() + ")");
        }
    }

    List<SqlStatement> parse(String sqlScriptSource) {
        if (this.resource != null) {
            LOG.debug("Parsing " + this.resource.getFilename() + " ...");
        }
        return this.linesToStatements(this.readLines(new StringReader(sqlScriptSource)));
    }

    List<SqlStatement> linesToStatements(List<String> lines) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        Delimiter nonStandardDelimiter = null;
        SqlStatementBuilder sqlStatementBuilder = this.createSqlStatementBuilder();
        for (int lineNumber = 1; lineNumber <= lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber - 1);
            if (sqlStatementBuilder.isEmpty()) {
                if (!StringUtils.hasText(line)) continue;
                Delimiter newDelimiter = sqlStatementBuilder.extractNewDelimiterFromLine(line);
                if (newDelimiter != null) {
                    nonStandardDelimiter = newDelimiter;
                    continue;
                }
                sqlStatementBuilder.setLineNumber(lineNumber);
                if (nonStandardDelimiter != null) {
                    sqlStatementBuilder.setDelimiter(nonStandardDelimiter);
                }
            }
            try {
                sqlStatementBuilder.addLine(line);
            }
            catch (Exception e) {
                throw new FlywayException("Flyway parsing bug (" + e.getMessage() + ") at line " + lineNumber + ": " + line, e);
            }
            if (sqlStatementBuilder.canDiscard()) {
                sqlStatementBuilder = this.createSqlStatementBuilder();
                continue;
            }
            if (!sqlStatementBuilder.isTerminated()) continue;
            this.addStatement(statements, sqlStatementBuilder);
            sqlStatementBuilder = this.createSqlStatementBuilder();
        }
        if (!sqlStatementBuilder.isEmpty()) {
            this.addStatement(statements, sqlStatementBuilder);
        }
        return statements;
    }

    protected SqlStatementBuilder createSqlStatementBuilder() {
        return this.database.createSqlStatementBuilder();
    }

    private void addStatement(List<SqlStatement> statements, SqlStatementBuilder sqlStatementBuilder) {
        SqlStatement sqlStatement = sqlStatementBuilder.getSqlStatement();
        statements.add(sqlStatement);
        if (sqlStatementBuilder.executeInTransaction()) {
            this.transactionalStatementFound = true;
        } else {
            this.nonTransactionalStatementFound = true;
        }
        if (!this.mixed && this.transactionalStatementFound && this.nonTransactionalStatementFound) {
            throw new FlywayException("Detected both transactional and non-transactional statements within the same migration (even though mixed is false). Offending statement found at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatementBuilder.executeInTransaction() ? "" : " [non-transactional]"));
        }
        LOG.debug("Found statement at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatementBuilder.executeInTransaction() ? "" : " [non-transactional]"));
    }

    private List<String> readLines(Reader reader) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            String message = this.resource == null ? "Unable to parse lines" : "Unable to parse " + this.resource.getLocation() + " (" + this.resource.getLocationOnDisk() + ")";
            throw new FlywayException(message, e);
        }
        return lines;
    }
}

