/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.saphana;

import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class SAPHANASqlStatementBuilder
extends SqlStatementBuilder {
    private static final Log LOG = LogFactory.getLog(SAPHANASqlStatementBuilder.class);
    private int beginEndNestedDepth = 0;
    private String statementStartNormalized = "";

    SAPHANASqlStatementBuilder() {
        super(Delimiter.SEMICOLON);
    }

    @Override
    protected String cleanToken(String token) {
        if (token.startsWith("N'") || token.startsWith("X'") || token.startsWith("DATE'") || token.startsWith("TIME'") || token.startsWith("TIMESTAMP'")) {
            return token.substring(token.indexOf("'"));
        }
        return super.cleanToken(token);
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        boolean insideStatementAllowingNestedBeginEndBlocks;
        if (this.hasNonCommentPart() && this.statementStartNormalized.length() < 16) {
            String effectiveLine = SAPHANASqlStatementBuilder.cutCommentsFromEnd(line);
            this.statementStartNormalized = this.statementStartNormalized + effectiveLine + " ";
            this.statementStartNormalized = StringUtils.trimLeadingWhitespace(StringUtils.collapseWhitespace(this.statementStartNormalized));
        }
        boolean bl = insideStatementAllowingNestedBeginEndBlocks = this.statementStartNormalized.startsWith("CREATE PROCEDURE") || this.statementStartNormalized.startsWith("CREATE FUNCTION") || this.statementStartNormalized.startsWith("CREATE TRIGGER") || this.statementStartNormalized.startsWith("DO");
        if (insideStatementAllowingNestedBeginEndBlocks) {
            if (line.startsWith("BEGIN")) {
                ++this.beginEndNestedDepth;
            }
            if (line.endsWith("END;")) {
                --this.beginEndNestedDepth;
                if (this.beginEndNestedDepth < 0) {
                    LOG.warn("SQL statement parsed unsuccessfully: found unpaired 'END;' in statement");
                }
                if (this.beginEndNestedDepth <= 0) {
                    insideStatementAllowingNestedBeginEndBlocks = false;
                }
            }
        }
        if (insideStatementAllowingNestedBeginEndBlocks) {
            return null;
        }
        return this.defaultDelimiter;
    }

    private static String cutCommentsFromEnd(String line) {
        int beginOfLineComment = line.indexOf("--");
        int beginOfBlockComment = line.indexOf("/*");
        if (-1 != beginOfLineComment) {
            if (-1 != beginOfBlockComment) {
                return line.substring(0, Math.min(beginOfBlockComment, beginOfLineComment));
            }
            return line.substring(0, beginOfLineComment);
        }
        if (-1 != beginOfBlockComment) {
            return line.substring(0, beginOfBlockComment);
        }
        return line;
    }
}

