/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sybasease;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;

public class SybaseASESqlStatementBuilder
extends SqlStatementBuilder {
    private static final Pattern KEYWORDS_BEFORE_STRING_LITERAL_REGEX = Pattern.compile("^(ELSE)('.*)");

    SybaseASESqlStatementBuilder() {
        super(Delimiter.GO);
    }

    @Override
    protected String computeAlternateCloseQuote(String openQuote) {
        char specialChar = openQuote.charAt(2);
        switch (specialChar) {
            case '(': {
                return ")'";
            }
        }
        return specialChar + "'";
    }

    @Override
    protected String cleanToken(String token) {
        Matcher beforeMatcher = KEYWORDS_BEFORE_STRING_LITERAL_REGEX.matcher(token);
        if (beforeMatcher.find()) {
            token = beforeMatcher.group(2);
        }
        return token;
    }
}

