/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.callback.DefaultCallbackExecutor;
import org.flywaydb.core.internal.callback.SqlScriptCallbackFactory;
import org.flywaydb.core.internal.clazz.ClassProvider;
import org.flywaydb.core.internal.clazz.NoopClassProvider;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbClean;
import org.flywaydb.core.internal.command.DbInfo;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.database.DatabaseFactory;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.license.FlywayProUpgradeRequiredException;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.resource.NoopResourceProvider;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.scanner.Scanner;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistoryFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.util.StringUtils;

public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private final ClassicConfiguration configuration;
    private boolean dbConnectionInfoPrinted;

    public static FluentConfiguration configure() {
        return new FluentConfiguration();
    }

    public static FluentConfiguration configure(ClassLoader classLoader) {
        return new FluentConfiguration(classLoader);
    }

    public Flyway(Configuration configuration) {
        this.configuration = new ClassicConfiguration(configuration);
    }

    public Configuration getConfiguration() {
        return new ClassicConfiguration(this.configuration);
    }

    public int migrate() throws FlywayException {
        return this.execute(new Command<Integer>(){

            @Override
            public Integer execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                if (Flyway.this.configuration.isValidateOnMigrate()) {
                    Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, true);
                }
                new DbSchemas(database, schemas, schemaHistory).create();
                if (!schemaHistory.exists()) {
                    ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                    for (Schema schema : schemas) {
                        if (schema.empty()) continue;
                        nonEmptySchemas.add(schema);
                    }
                    if (!nonEmptySchemas.isEmpty()) {
                        if (Flyway.this.configuration.isBaselineOnMigrate()) {
                            Flyway.this.doBaseline(schemaHistory, database, schemas, callbackExecutor);
                        } else if (!schemaHistory.exists()) {
                            throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " without schema history table! Use baseline() or set baselineOnMigrate to true to initialize the schema history table.");
                        }
                    }
                }
                return new DbMigrate(database, schemaHistory, schemas[0], migrationResolver, Flyway.this.configuration, callbackExecutor).migrate();
            }
        }, true);
    }

    private void doBaseline(SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
        new DbBaseline(database, schemaHistory, schemas[0], this.configuration.getBaselineVersion(), this.configuration.getBaselineDescription(), callbackExecutor).baseline();
    }

    public int undo() throws FlywayException {
        throw new FlywayProUpgradeRequiredException("undo");
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, Flyway.this.configuration.isIgnorePendingMigrations());
                return null;
            }
        }, true);
    }

    private void doValidate(Database database, MigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor, boolean ignorePending) {
        String validationError = new DbValidate(database, schemaHistory, schemas[0], migrationResolver, this.configuration, ignorePending, callbackExecutor).validate();
        if (validationError != null) {
            if (this.configuration.isCleanOnValidationError()) {
                this.doClean(database, schemaHistory, schemas, callbackExecutor);
            } else {
                throw new FlywayException("Validate failed: " + validationError);
            }
        }
    }

    private void doClean(Database database, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor) {
        new DbClean(database, schemaHistory, schemas, callbackExecutor, this.configuration.isCleanDisabled()).clean();
    }

    public void clean() {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                Flyway.this.doClean(database, schemaHistory, schemas, callbackExecutor);
                return null;
            }
        }, false);
    }

    public MigrationInfoService info() {
        return this.execute(new Command<MigrationInfoService>(){

            @Override
            public MigrationInfoService execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                return new DbInfo(migrationResolver, schemaHistory, Flyway.this.configuration, callbackExecutor).info();
            }
        }, true);
    }

    public void baseline() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                new DbSchemas(database, schemas, schemaHistory).create();
                Flyway.this.doBaseline(schemaHistory, database, schemas, callbackExecutor);
                return null;
            }
        }, false);
    }

    public void repair() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                new DbRepair(database, migrationResolver, schemaHistory, callbackExecutor, Flyway.this.configuration).repair();
                return null;
            }
        }, true);
    }

    private MigrationResolver createMigrationResolver(Database database, ResourceProvider resourceProvider, ClassProvider classProvider, SqlScriptFactory sqlScriptFactory) {
        return new CompositeMigrationResolver(database, resourceProvider, classProvider, this.configuration, sqlScriptFactory, this.configuration.getResolvers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Command<T> command, boolean scannerRequired) {
        T result;
        VersionPrinter.printVersion();
        if (this.configuration.getDataSource() == null) {
            throw new FlywayException("Unable to connect to the database. Configure the url, user and password!");
        }
        Database database = null;
        try {
            ClassProvider classProvider;
            ResourceProvider resourceProvider;
            database = DatabaseFactory.createDatabase(this.configuration, !this.dbConnectionInfoPrinted);
            this.dbConnectionInfoPrinted = true;
            LOG.debug("DDL Transactions Supported: " + database.supportsDdlTransactions());
            Schema[] schemas = this.prepareSchemas(database);
            if (!scannerRequired && this.configuration.isSkipDefaultResolvers() && this.configuration.isSkipDefaultCallbacks()) {
                resourceProvider = NoopResourceProvider.INSTANCE;
                classProvider = NoopClassProvider.INSTANCE;
            } else {
                Scanner scanner = new Scanner(Arrays.asList(this.configuration.getLocations()), this.configuration.getClassLoader(), this.configuration.getEncoding());
                resourceProvider = scanner;
                classProvider = scanner;
            }
            DefaultCallbackExecutor callbackExecutor = new DefaultCallbackExecutor(this.configuration, database, schemas[0], this.prepareCallbacks(database, resourceProvider, database));
            result = command.execute(this.createMigrationResolver(database, resourceProvider, classProvider, database), SchemaHistoryFactory.getSchemaHistory(this.configuration, database, schemas[0]), database, schemas, callbackExecutor);
        }
        finally {
            if (database != null) {
                database.close();
            }
            this.showMemoryUsage();
        }
        return result;
    }

    private void showMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        long totalMB = total / 0x100000L;
        long usedMB = used / 0x100000L;
        LOG.debug("Memory usage: " + usedMB + " of " + totalMB + "M");
    }

    private Schema[] prepareSchemas(Database database) {
        Object[] schemaNames = this.configuration.getSchemas();
        if (schemaNames.length == 0) {
            Schema currentSchema = ((Connection)database.getMainConnection()).getCurrentSchema();
            if (currentSchema == null) {
                throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the schemas property!");
            }
            schemaNames = new String[]{currentSchema.getName()};
        }
        if (schemaNames.length == 1) {
            LOG.debug("Schema: " + (String)schemaNames[0]);
        } else {
            LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(schemaNames));
        }
        Schema[] schemas = new Schema[schemaNames.length];
        for (int i = 0; i < schemaNames.length; ++i) {
            schemas[i] = ((Connection)database.getMainConnection()).getSchema((String)schemaNames[i]);
        }
        return schemas;
    }

    private List<Callback> prepareCallbacks(Database database, ResourceProvider resourceProvider, SqlScriptFactory sqlScriptFactory) {
        ArrayList<Callback> effectiveCallbacks = new ArrayList<Callback>();
        effectiveCallbacks.addAll(Arrays.asList(this.configuration.getCallbacks()));
        if (!this.configuration.isSkipDefaultCallbacks()) {
            effectiveCallbacks.addAll(new SqlScriptCallbackFactory(database, resourceProvider, sqlScriptFactory, this.configuration).getCallbacks());
        }
        return effectiveCallbacks;
    }

    static interface Command<T> {
        public T execute(MigrationResolver var1, SchemaHistory var2, Database var3, Schema[] var4, CallbackExecutor var5);
    }
}

