/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.mysql.MySQLConnection;
import org.flywaydb.core.internal.database.mysql.MySQLParser;
import org.flywaydb.core.internal.jdbc.DatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;

public class MySQLDatabase
extends Database<MySQLConnection> {
    private static final Log LOG = LogFactory.getLog(MySQLDatabase.class);
    private final boolean pxcStrict;

    public MySQLDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
        this.pxcStrict = MySQLDatabase.isRunningInPerconaXtraDBClusterWithStrictMode(connection);
    }

    static boolean isRunningInPerconaXtraDBClusterWithStrictMode(Connection connection) {
        try {
            if ("ENFORCING".equals(new JdbcTemplate(connection).queryForString("select VARIABLE_VALUE from performance_schema.global_variables where variable_name = 'pxc_strict_mode'", new String[0]))) {
                LOG.debug("Detected Percona XtraDB Cluster in strict mode");
                return true;
            }
        }
        catch (SQLException e) {
            LOG.debug("Unable to detect whether we are running in a Percona XtraDB Cluster. Assuming not to be.");
        }
        return false;
    }

    boolean isMariaDB() {
        return this.databaseType == DatabaseType.MARIADB;
    }

    boolean isPxcStrict() {
        return this.pxcStrict;
    }

    @Override
    protected SqlScript getCreateScript(Map<String, String> placeholders) {
        MySQLParser parser = new MySQLParser(new FluentConfiguration().placeholders(placeholders));
        return new ParserSqlScript(parser, this.getRawCreateScript(), false);
    }

    @Override
    protected LoadableResource getRawCreateScript() {
        String tablespace = this.configuration.getTablespace() == null ? "" : " TABLESPACE \"" + this.configuration.getTablespace() + "\"";
        return new StringResource("CREATE TABLE `${schema}`.`${table}` (\n    `installed_rank` INT NOT NULL,\n    `version` VARCHAR(50),\n    `description` VARCHAR(200) NOT NULL,\n    `type` VARCHAR(20) NOT NULL,\n    `script` VARCHAR(1000) NOT NULL,\n    `checksum` INT,\n    `installed_by` VARCHAR(100) NOT NULL,\n    `installed_on` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n    `execution_time` INT NOT NULL,\n    `success` BOOL NOT NULL,\n    -- Add the primary key as part of the CREATE TABLE statement in case `innodb_force_primary_key` is enabled\n    CONSTRAINT `${table}_pk`PRIMARY KEY (`installed_rank`)\n)" + tablespace + " ENGINE=InnoDB;\n\nCREATE INDEX `${table}_s_idx` ON `${schema}`.`${table}` (`success`);");
    }

    @Override
    protected MySQLConnection getConnection(Connection connection) {
        return new MySQLConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("5.1");
        if (this.databaseType == DatabaseType.MARIADB) {
            this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("10.1", Edition.ENTERPRISE);
            this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("10.2", Edition.PRO);
            this.recommendFlywayUpgradeIfNecessary("10.4");
        } else {
            this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("5.7", Edition.ENTERPRISE);
            if (JdbcUtils.getDriverName(this.jdbcMetaData).contains("MariaDB")) {
                LOG.warn("You are connected to a MySQL " + this.getVersion() + " database using the MariaDB driver. This is known to cause issues. An upgrade to Oracle's MySQL JDBC driver is highly recommended.");
            }
            this.recommendFlywayUpgradeIfNecessary("8.0");
        }
    }

    @Override
    public SqlScript createSqlScript(LoadableResource resource, boolean mixed) {
        return new ParserSqlScript(new MySQLParser(this.configuration), resource, mixed);
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((MySQLConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SUBSTRING_INDEX(USER(),'@',1)", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public boolean useSingleConnection() {
        return !this.pxcStrict;
    }
}

