/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.mysql.MySQLDatabase;
import org.flywaydb.core.internal.database.mysql.MySQLTable;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class MySQLSchema
extends Schema<MySQLDatabase> {
    MySQLSchema(JdbcTemplate jdbcTemplate, MySQLDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT (SELECT 1 FROM information_schema.schemata WHERE schema_name=? LIMIT 1)", this.name) > 0;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT SUM(found) FROM ((SELECT 1 as found FROM information_schema.tables WHERE table_schema=?) UNION ALL (SELECT 1 as found FROM information_schema.views WHERE table_schema=? LIMIT 1) UNION ALL (SELECT 1 as found FROM information_schema.table_constraints WHERE table_schema=? LIMIT 1) UNION ALL (SELECT 1 as found FROM information_schema.events WHERE event_schema=? LIMIT 1) UNION ALL (SELECT 1 as found FROM information_schema.triggers WHERE trigger_schema=? LIMIT 1) UNION ALL (SELECT 1 as found FROM information_schema.routines WHERE routine_schema=? LIMIT 1)) as all_found", this.name, this.name, this.name, this.name, this.name, this.name) == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((MySQLDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((MySQLDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (String statement : this.cleanEvents()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanRoutines()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        this.jdbcTemplate.execute("SET FOREIGN_KEY_CHECKS = 0", new Object[0]);
        for (Table table : this.allTables()) {
            table.drop();
        }
        this.jdbcTemplate.execute("SET FOREIGN_KEY_CHECKS = 1", new Object[0]);
        for (String statement : this.cleanSequences()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> cleanEvents() throws SQLException {
        List<String> eventNames = this.jdbcTemplate.queryForStringList("SELECT event_name FROM information_schema.events WHERE event_schema=?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String eventName : eventNames) {
            statements.add("DROP EVENT " + ((MySQLDatabase)this.database).quote(this.name, eventName));
        }
        return statements;
    }

    private List<String> cleanRoutines() throws SQLException {
        List<Map<String, String>> routineNames = this.jdbcTemplate.queryForList("SELECT routine_name as 'N', routine_type as 'T' FROM information_schema.routines WHERE routine_schema=?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : routineNames) {
            String routineName = row.get("N");
            String routineType = row.get("T");
            statements.add("DROP " + routineType + " " + ((MySQLDatabase)this.database).quote(this.name, routineName));
        }
        return statements;
    }

    private List<String> cleanViews() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT table_name FROM information_schema.views WHERE table_schema=?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String viewName : viewNames) {
            statements.add("DROP VIEW " + ((MySQLDatabase)this.database).quote(this.name, viewName));
        }
        return statements;
    }

    private List<String> cleanSequences() throws SQLException {
        List<String> names = this.jdbcTemplate.queryForStringList("SELECT table_name FROM information_schema.tables WHERE table_schema=? AND table_type='SEQUENCE'", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String name : names) {
            statements.add("DROP SEQUENCE " + ((MySQLDatabase)this.database).quote(this.name, name));
        }
        return statements;
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT table_name FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'", this.name);
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new MySQLTable(this.jdbcTemplate, (MySQLDatabase)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new MySQLTable(this.jdbcTemplate, (MySQLDatabase)this.database, this, tableName);
    }
}

