/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlite;

import java.sql.Connection;
import java.util.Map;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.sqlite.SQLiteConnection;
import org.flywaydb.core.internal.database.sqlite.SQLiteParser;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;

public class SQLiteDatabase
extends Database<SQLiteConnection> {
    public SQLiteDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected SQLiteConnection getConnection(Connection connection) {
        return new SQLiteConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("3.0");
    }

    @Override
    protected SqlScript getCreateScript(Map<String, String> placeholders) {
        SQLiteParser parser = new SQLiteParser(new FluentConfiguration().placeholders(placeholders));
        return new ParserSqlScript(parser, this.getRawCreateScript(), false);
    }

    @Override
    protected LoadableResource getRawCreateScript() {
        return new StringResource("CREATE TABLE \"${schema}\".\"${table}\" (\n    \"installed_rank\" INT NOT NULL PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TEXT NOT NULL DEFAULT (strftime('%Y-%m-%d %H:%M:%f','now')),\n    \"execution_time\" INT NOT NULL,\n    \"success\" BOOLEAN NOT NULL\n);\n\nCREATE INDEX \"${schema}\".\"${table}_s_idx\" ON \"${table}\" (\"success\");");
    }

    @Override
    public SqlScript createSqlScript(LoadableResource resource, boolean mixed) {
        return new ParserSqlScript(new SQLiteParser(this.configuration), resource, mixed);
    }

    public String getDbName() {
        return "sqlite";
    }

    @Override
    protected String doGetCurrentUser() {
        return "";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

