/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.jdbc.JdbcUtils;

public enum DatabaseType {
    COCKROACHDB("CockroachDB", 0),
    DB2("DB2", 12),
    DERBY("Derby", 12),
    H2("H2", 12),
    HSQLDB("HSQLDB", 12),
    INFORMIX("Informix", 12),
    MARIADB("MariaDB", 12),
    MYSQL("MySQL", 12),
    ORACLE("Oracle", 12),
    POSTGRESQL("PostgreSQL", 0),
    REDSHIFT("Redshift", 12),
    SQLITE("SQLite", 12),
    SQLSERVER("SQL Server", 12),
    SYBASEASE_JTDS("Sybase ASE", 0),
    SYBASEASE_JCONNECT("Sybase ASE", 12),
    SAPHANA("SAP HANA", 12);

    private final String name;
    private final int nullType;

    private DatabaseType(String name, int nullType) {
        this.name = name;
        this.nullType = nullType;
    }

    public static DatabaseType fromJdbcConnection(Connection connection) {
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(connection);
        String databaseProductName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        String databaseProductVersion = JdbcUtils.getDatabaseProductVersion(databaseMetaData);
        String postgreSQLVersion = databaseProductName.startsWith("PostgreSQL") ? DatabaseType.getPostgreSQLVersion(connection) : "";
        return DatabaseType.fromDatabaseProductNameAndPostgreSQLVersion(databaseProductName, databaseProductVersion, postgreSQLVersion);
    }

    private static DatabaseType fromDatabaseProductNameAndPostgreSQLVersion(String databaseProductName, String databaseProductVersion, String postgreSQLVersion) {
        if (databaseProductName.startsWith("Apache Derby")) {
            return DERBY;
        }
        if (databaseProductName.startsWith("SQLite")) {
            return SQLITE;
        }
        if (databaseProductName.startsWith("H2")) {
            return H2;
        }
        if (databaseProductName.contains("HSQL Database Engine")) {
            return HSQLDB;
        }
        if (databaseProductName.startsWith("Microsoft SQL Server")) {
            return SQLSERVER;
        }
        if (databaseProductName.startsWith("MariaDB") || databaseProductName.contains("MySQL") && databaseProductVersion.contains("MariaDB")) {
            return MARIADB;
        }
        if (databaseProductName.contains("MySQL")) {
            return MYSQL;
        }
        if (databaseProductName.startsWith("Oracle")) {
            return ORACLE;
        }
        if (databaseProductName.startsWith("PostgreSQL 8") && postgreSQLVersion.contains("Redshift")) {
            return REDSHIFT;
        }
        if (databaseProductName.startsWith("PostgreSQL")) {
            if (postgreSQLVersion.contains("CockroachDB")) {
                return COCKROACHDB;
            }
            return POSTGRESQL;
        }
        if (databaseProductName.startsWith("DB2")) {
            return DB2;
        }
        if (databaseProductName.startsWith("ASE")) {
            return SYBASEASE_JTDS;
        }
        if (databaseProductName.startsWith("Adaptive Server Enterprise")) {
            return SYBASEASE_JCONNECT;
        }
        if (databaseProductName.startsWith("HDB")) {
            return SAPHANA;
        }
        if (databaseProductName.startsWith("Informix")) {
            return INFORMIX;
        }
        throw new FlywayException("Unsupported Database: " + databaseProductName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPostgreSQLVersion(Connection connection) {
        String result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT version()");
            resultSet = statement.executeQuery();
            result = null;
            if (resultSet.next()) {
                result = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            String string;
            try {
                string = "";
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            return string;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public int getNullType() {
        return this.nullType;
    }

    public String toString() {
        return this.name;
    }
}

