/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.WikiPage;

public class WikisApi
extends AbstractApi {
    public WikisApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<WikiPage> getPages(Integer projectId) throws GitLabApiException {
        return this.getPages(projectId, 1, this.getDefaultPerPage());
    }

    public List<WikiPage> getPages(Integer projectId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "wikis");
        return (List)response.readEntity((GenericType)new GenericType<List<WikiPage>>(){});
    }

    public Pager<WikiPage> getPages(Integer projectId, int itemsPerPage) throws GitLabApiException {
        return new Pager<WikiPage>(this, WikiPage.class, itemsPerPage, null, "projects", projectId, "wikis");
    }

    public WikiPage getPage(Integer projectId, String slug) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "wikis", slug);
        return (WikiPage)response.readEntity(WikiPage.class);
    }

    public Optional<WikiPage> getOptionalPage(Integer projectId, String slug) {
        try {
            return Optional.ofNullable(this.getPage(projectId, slug));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public WikiPage createPage(Integer projectId, String title, String content) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("content", content);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", projectId, "wikis"});
        return (WikiPage)response.readEntity(WikiPage.class);
    }

    public WikiPage updatePage(Integer projectId, String slug, String title, String content) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("slug", slug, true).withParam("content", content);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "wikis", slug);
        return (WikiPage)response.readEntity(WikiPage.class);
    }

    public void deletePage(Integer projectId, String slug) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", projectId, "wikis", slug);
    }
}

