/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.gitlab4j.api.utils.SecretString;

public class Oauth2LoginStreamingOutput
implements StreamingOutput,
AutoCloseable {
    private final String username;
    private final SecretString password;

    public Oauth2LoginStreamingOutput(String username, CharSequence password) {
        this.username = username;
        this.password = new SecretString(password);
    }

    public Oauth2LoginStreamingOutput(String username, char[] password) {
        this.username = username;
        this.password = new SecretString(password);
    }

    public void write(OutputStream output) throws IOException, WebApplicationException {
        PrintWriter writer = new PrintWriter(output);
        writer.write("{ ");
        writer.write("\"grant_type\": \"password\", ");
        writer.write("\"username\": \"" + this.username + "\", ");
        writer.write("\"password\": ");
        writer.write(34);
        int length = this.password.length();
        for (int i = 0; i < length; ++i) {
            writer.write(this.password.charAt(i));
        }
        writer.write(34);
        writer.write(" }");
        writer.flush();
        writer.close();
    }

    public void clearPassword() {
        this.password.clear();
    }

    @Override
    public void close() {
        this.clearPassword();
    }

    public void finalize() throws Throwable {
        this.clearPassword();
        super.finalize();
    }
}

