/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalMaxValidatorForNumber
implements ConstraintValidator<DecimalMax, Number> {
    private BigDecimal maxValue;

    @Override
    public void initialize(DecimalMax maxValue) {
        try {
            this.maxValue = new BigDecimal(maxValue.value());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(maxValue.value() + " does not represent a valid BigDecimal format", nfe);
        }
    }

    @Override
    public boolean isValid(Number value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(this.maxValue) != 1;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value).compareTo(this.maxValue) != 1;
        }
        return BigDecimal.valueOf(value.longValue()).compareTo(this.maxValue) != 1;
    }
}

