/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.scriptengine;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;

final class GraalJSBindings
extends AbstractMap<String, Object>
implements Bindings,
AutoCloseable {
    private static final TypeLiteral<Map<String, Object>> STRING_MAP = new TypeLiteral<Map<String, Object>>(){};
    private Context context;
    private Map<String, Object> global;
    private Value deleteProperty;
    private Value clear;
    private Context.Builder contextBuilder;

    GraalJSBindings(Context.Builder contextBuilder) {
        this.contextBuilder = contextBuilder;
    }

    GraalJSBindings(Context context) {
        this.context = context;
        this.initGlobal();
    }

    private void requireContext() {
        if (this.context == null) {
            this.initContext();
        }
    }

    private void initContext() {
        this.context = GraalJSScriptEngine.createDefaultContext(this.contextBuilder);
        this.initGlobal();
    }

    private void initGlobal() {
        this.global = (Map)GraalJSScriptEngine.evalInternal(this.context, "this").as(STRING_MAP);
    }

    private Value deletePropertyFunction() {
        if (this.deleteProperty == null) {
            this.deleteProperty = GraalJSScriptEngine.evalInternal(this.context, "(function(obj, prop) {delete obj[prop]})");
        }
        return this.deleteProperty;
    }

    private Value clearFunction() {
        if (this.clear == null) {
            this.clear = GraalJSScriptEngine.evalInternal(this.context, "(function(obj) {for (var prop in obj) {delete obj[prop]}})");
        }
        return this.clear;
    }

    @Override
    public Object put(String name, Object v) {
        if (name.startsWith("polyglot.js.")) {
            if (this.context == null) {
                GraalJSScriptEngine.MagicBindingsOptionSetter optionSetter = (GraalJSScriptEngine.MagicBindingsOptionSetter)GraalJSScriptEngine.MAGIC_BINDINGS_OPTION_MAP.get((Object)name);
                if (optionSetter == null) {
                    throw new IllegalArgumentException("unkown graal-js option \"" + name + "\"");
                }
                this.contextBuilder = optionSetter.setOption(this.contextBuilder, v);
                return true;
            }
            throw GraalJSBindings.magicOptionContextInitializedError(name);
        }
        this.requireContext();
        return this.global.put(name, v);
    }

    @Override
    public void clear() {
        if (this.context != null) {
            this.clearFunction().execute(new Object[]{this.global});
        }
    }

    @Override
    public Object get(Object key) {
        this.requireContext();
        return this.global.get(key);
    }

    @Override
    public Object remove(Object key) {
        this.requireContext();
        Object prev = this.get(key);
        this.deletePropertyFunction().execute(new Object[]{this.global, key});
        return prev;
    }

    public Context getContext() {
        this.requireContext();
        return this.context;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.requireContext();
        return this.global.entrySet();
    }

    @Override
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    private static IllegalStateException magicOptionContextInitializedError(String name) {
        return new IllegalStateException(String.format("failed to set graal-js option \"%s\": js context is already initialized", name));
    }
}

