/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.build.internal;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import javax.persistence.metamodel.Attribute;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.GraphNodeImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.loader.plan.build.internal.AbstractLoadPlanBuildingAssociationVisitationStrategy;
import org.hibernate.loader.plan.build.internal.LoadPlanImpl;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.QuerySpaces;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.CollectionDefinition;
import org.hibernate.persister.walking.spi.CollectionElementDefinition;
import org.hibernate.persister.walking.spi.CollectionIndexDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.persister.walking.spi.EntityDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.jboss.logging.Logger;

public abstract class AbstractEntityGraphVisitationStrategy
extends AbstractLoadPlanBuildingAssociationVisitationStrategy {
    private static final Logger LOG = CoreLogging.logger(AbstractEntityGraphVisitationStrategy.class);
    protected static final FetchStrategy DEFAULT_EAGER = new FetchStrategy(FetchTiming.IMMEDIATE, FetchStyle.JOIN);
    protected static final FetchStrategy DEFAULT_LAZY = new FetchStrategy(FetchTiming.DELAYED, FetchStyle.SELECT);
    protected final LoadQueryInfluencers loadQueryInfluencers;
    protected final ArrayDeque<GraphNodeImplementor> graphStack = new ArrayDeque();
    protected final ArrayDeque<AttributeNodeImplementor> attributeStack = new ArrayDeque();
    protected Map<String, AttributeNodeImplementor> attributeNodeImplementorMap = Collections.emptyMap();
    private EntityReturn rootEntityReturn;
    private final LockMode lockMode;
    private static final AttributeNodeImplementor NON_EXIST_ATTRIBUTE_NODE = new AttributeNodeImplementor(){

        public Attribute getAttribute() {
            return null;
        }

        public AttributeNodeImplementor makeImmutableCopy() {
            return this;
        }

        public String getAttributeName() {
            return null;
        }

        public Map<Class, Subgraph> getSubgraphs() {
            return Collections.emptyMap();
        }

        public Map<Class, Subgraph> getKeySubgraphs() {
            return Collections.emptyMap();
        }

        public String toString() {
            return "Mocked NON-EXIST attribute node";
        }
    };
    private static final GraphNodeImplementor NON_EXIST_SUBGRAPH_NODE = new GraphNodeImplementor(){

        @Override
        public List<AttributeNodeImplementor<?>> attributeImplementorNodes() {
            return Collections.emptyList();
        }

        @Override
        public List<AttributeNode<?>> attributeNodes() {
            return Collections.emptyList();
        }
    };

    protected AbstractEntityGraphVisitationStrategy(SessionFactoryImplementor sessionFactory, LoadQueryInfluencers loadQueryInfluencers, LockMode lockMode) {
        super(sessionFactory);
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.lockMode = lockMode;
    }

    @Override
    public void start() {
        super.start();
        this.graphStack.addLast(this.getRootEntityGraph());
    }

    @Override
    public void finish() {
        super.finish();
        this.graphStack.removeLast();
        if (!(this.graphStack.isEmpty() && this.attributeStack.isEmpty() && this.attributeNodeImplementorMap.isEmpty())) {
            throw new WalkingException("Internal stack error");
        }
    }

    @Override
    public void startingEntity(EntityDefinition entityDefinition) {
        this.attributeNodeImplementorMap = this.buildAttributeNodeMap();
        super.startingEntity(entityDefinition);
    }

    protected Map<String, AttributeNodeImplementor> buildAttributeNodeMap() {
        GraphNodeImplementor graphNode = this.graphStack.peekLast();
        List<AttributeNodeImplementor<?>> attributeNodeImplementors = graphNode.attributeImplementorNodes();
        HashMap<String, AttributeNodeImplementor> attributeNodeImplementorMap = attributeNodeImplementors.isEmpty() ? Collections.emptyMap() : new HashMap<String, AttributeNodeImplementor>(attributeNodeImplementors.size());
        for (AttributeNodeImplementor<?> attribute : attributeNodeImplementors) {
            attributeNodeImplementorMap.put(attribute.getAttributeName(), attribute);
        }
        return attributeNodeImplementorMap;
    }

    @Override
    public void finishingEntity(EntityDefinition entityDefinition) {
        this.attributeNodeImplementorMap = Collections.emptyMap();
        super.finishingEntity(entityDefinition);
    }

    @Override
    public boolean startingAttribute(AttributeDefinition attributeDefinition) {
        String attrName = attributeDefinition.getName();
        AttributeNodeImplementor attributeNode = NON_EXIST_ATTRIBUTE_NODE;
        GraphNodeImplementor subGraphNode = NON_EXIST_SUBGRAPH_NODE;
        if (this.attributeNodeImplementorMap.containsKey(attrName)) {
            attributeNode = this.attributeNodeImplementorMap.get(attrName);
            Map subGraphs = attributeNode.getSubgraphs();
            Class javaType = attributeDefinition.getType().getReturnedClass();
            if (!subGraphs.isEmpty() && subGraphs.containsKey(javaType)) {
                subGraphNode = (GraphNodeImplementor)subGraphs.get(javaType);
            }
        }
        this.attributeStack.addLast(attributeNode);
        this.graphStack.addLast(subGraphNode);
        return super.startingAttribute(attributeDefinition);
    }

    @Override
    public void finishingAttribute(AttributeDefinition attributeDefinition) {
        this.attributeStack.removeLast();
        this.graphStack.removeLast();
        super.finishingAttribute(attributeDefinition);
    }

    @Override
    protected boolean handleAssociationAttribute(AssociationAttributeDefinition attributeDefinition) {
        return super.handleAssociationAttribute(attributeDefinition);
    }

    @Override
    protected boolean handleCompositeAttribute(AttributeDefinition attributeDefinition) {
        return super.handleCompositeAttribute(attributeDefinition);
    }

    @Override
    public void startingComposite(CompositionDefinition compositionDefinition) {
        super.startingComposite(compositionDefinition);
    }

    @Override
    public void finishingComposite(CompositionDefinition compositionDefinition) {
        super.finishingComposite(compositionDefinition);
    }

    @Override
    public void startingCollection(CollectionDefinition collectionDefinition) {
        super.startingCollection(collectionDefinition);
    }

    @Override
    public void finishingCollection(CollectionDefinition collectionDefinition) {
        super.finishingCollection(collectionDefinition);
    }

    @Override
    public void startingCollectionElements(CollectionElementDefinition elementDefinition) {
        super.startingCollectionElements(elementDefinition);
    }

    @Override
    public void finishingCollectionElements(CollectionElementDefinition elementDefinition) {
        super.finishingCollectionElements(elementDefinition);
    }

    @Override
    public void startingCollectionIndex(CollectionIndexDefinition indexDefinition) {
        AttributeNodeImplementor attributeNode = this.attributeStack.peekLast();
        GraphNodeImplementor subGraphNode = NON_EXIST_SUBGRAPH_NODE;
        Map subGraphs = attributeNode.getKeySubgraphs();
        Class javaType = indexDefinition.getType().getReturnedClass();
        if (!subGraphs.isEmpty() && subGraphs.containsKey(javaType)) {
            subGraphNode = (GraphNodeImplementor)subGraphs.get(javaType);
        }
        this.graphStack.addLast(subGraphNode);
        super.startingCollectionIndex(indexDefinition);
    }

    @Override
    public void finishingCollectionIndex(CollectionIndexDefinition indexDefinition) {
        super.finishingCollectionIndex(indexDefinition);
        this.graphStack.removeLast();
    }

    @Override
    protected boolean supportsRootCollectionReturns() {
        return false;
    }

    @Override
    protected void addRootReturn(Return rootReturn) {
        if (this.rootEntityReturn != null) {
            throw new HibernateException("Root return already identified");
        }
        if (!(rootReturn instanceof EntityReturn)) {
            throw new HibernateException("Load entity graph only supports EntityReturn");
        }
        this.rootEntityReturn = (EntityReturn)rootReturn;
    }

    @Override
    protected FetchStrategy determineFetchStrategy(AssociationAttributeDefinition attributeDefinition) {
        return this.attributeStack.peekLast() != NON_EXIST_ATTRIBUTE_NODE ? DEFAULT_EAGER : this.resolveImplicitFetchStrategyFromEntityGraph(attributeDefinition);
    }

    protected abstract FetchStrategy resolveImplicitFetchStrategyFromEntityGraph(AssociationAttributeDefinition var1);

    protected FetchStrategy adjustJoinFetchIfNeeded(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy) {
        if (this.lockMode.greaterThan(LockMode.READ)) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        Integer maxFetchDepth = this.sessionFactory().getSettings().getMaximumFetchDepth();
        if (maxFetchDepth != null && this.currentDepth() > maxFetchDepth) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        if (attributeDefinition.getType().isCollectionType() && this.isTooManyCollections()) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        return fetchStrategy;
    }

    @Override
    public LoadPlan buildLoadPlan() {
        LOG.debug((Object)"Building LoadPlan...");
        return new LoadPlanImpl(this.rootEntityReturn, (QuerySpaces)this.getQuerySpaces());
    }

    protected abstract GraphNodeImplementor getRootEntityGraph();
}

