/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.List;
import org.hibernate.FetchMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbManyToOneElement;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.binder.ToOneAttributeSource;
import org.hibernate.metamodel.source.hbm.Helper;

class ManyToOneAttributeSourceImpl
implements ToOneAttributeSource {
    private final JaxbManyToOneElement manyToOneElement;
    private final LocalBindingContext bindingContext;
    private final List<RelationalValueSource> valueSources;

    ManyToOneAttributeSourceImpl(final JaxbManyToOneElement manyToOneElement, LocalBindingContext bindingContext) {
        this.manyToOneElement = manyToOneElement;
        this.bindingContext = bindingContext;
        this.valueSources = Helper.buildValueSources(new Helper.ValueSourcesAdapter(){

            @Override
            public String getColumnAttribute() {
                return manyToOneElement.getColumn();
            }

            @Override
            public String getFormulaAttribute() {
                return manyToOneElement.getFormula();
            }

            @Override
            public List getColumnOrFormulaElements() {
                return manyToOneElement.getColumnOrFormula();
            }

            @Override
            public String getContainingTableName() {
                return null;
            }

            @Override
            public boolean isIncludedInInsertByDefault() {
                return manyToOneElement.isInsert();
            }

            @Override
            public boolean isIncludedInUpdateByDefault() {
                return manyToOneElement.isUpdate();
            }
        }, bindingContext);
    }

    @Override
    public String getName() {
        return this.manyToOneElement.getName();
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return Helper.TO_ONE_ATTRIBUTE_TYPE_SOURCE;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.manyToOneElement.getAccess();
    }

    @Override
    public boolean isInsertable() {
        return this.manyToOneElement.isInsert();
    }

    @Override
    public boolean isUpdatable() {
        return this.manyToOneElement.isUpdate();
    }

    @Override
    public PropertyGeneration getGeneration() {
        return PropertyGeneration.NEVER;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.manyToOneElement.isOptimisticLock();
    }

    @Override
    public Iterable<CascadeStyle> getCascadeStyles() {
        return Helper.interpretCascadeStyles(this.manyToOneElement.getCascade(), this.bindingContext);
    }

    @Override
    public FetchTiming getFetchTiming() {
        String outerJoinSelection;
        String fetchSelection = this.manyToOneElement.getFetch() != null ? this.manyToOneElement.getFetch().value() : null;
        String lazySelection = this.manyToOneElement.getLazy() != null ? this.manyToOneElement.getLazy().value() : null;
        String string = outerJoinSelection = this.manyToOneElement.getOuterJoin() != null ? this.manyToOneElement.getOuterJoin().value() : null;
        if (lazySelection == null) {
            if ("join".equals(fetchSelection) || "true".equals(outerJoinSelection)) {
                return FetchTiming.IMMEDIATE;
            }
            if ("false".equals(outerJoinSelection)) {
                return FetchTiming.DELAYED;
            }
            return this.bindingContext.getMappingDefaults().areAssociationsLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE;
        }
        if ("extra".equals(lazySelection)) {
            return FetchTiming.EXTRA_LAZY;
        }
        if ("true".equals(lazySelection)) {
            return FetchTiming.DELAYED;
        }
        if ("false".equals(lazySelection)) {
            return FetchTiming.IMMEDIATE;
        }
        throw new MappingException(String.format("Unexpected lazy selection [%s] on '%s'", lazySelection, this.manyToOneElement.getName()), this.bindingContext.getOrigin());
    }

    @Override
    public FetchStyle getFetchStyle() {
        String outerJoinSelection;
        String fetchSelection = this.manyToOneElement.getFetch() != null ? this.manyToOneElement.getFetch().value() : null;
        String string = outerJoinSelection = this.manyToOneElement.getOuterJoin() != null ? this.manyToOneElement.getOuterJoin().value() : null;
        if (fetchSelection == null) {
            if (outerJoinSelection == null) {
                return FetchStyle.SELECT;
            }
            if ("auto".equals(outerJoinSelection)) {
                return this.bindingContext.getMappingDefaults().areAssociationsLazy() ? FetchStyle.SELECT : FetchStyle.JOIN;
            }
            return "true".equals(outerJoinSelection) ? FetchStyle.JOIN : FetchStyle.SELECT;
        }
        return "join".equals(fetchSelection) ? FetchStyle.JOIN : FetchStyle.SELECT;
    }

    @Override
    public FetchMode getFetchMode() {
        return this.manyToOneElement.getFetch() == null ? FetchMode.DEFAULT : FetchMode.valueOf(this.manyToOneElement.getFetch().value());
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.MANY_TO_ONE;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return this.manyToOneElement.isInsert();
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return this.manyToOneElement.isUpdate();
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return !Helper.getBooleanValue(this.manyToOneElement.isNotNull(), false);
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return this.valueSources;
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.manyToOneElement.getMeta());
    }

    @Override
    public String getReferencedEntityName() {
        return this.manyToOneElement.getClazz() != null ? this.manyToOneElement.getClazz() : this.manyToOneElement.getEntityName();
    }

    @Override
    public String getReferencedEntityAttributeName() {
        return this.manyToOneElement.getPropertyRef();
    }
}

