/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.metamodel;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.jpa.internal.metamodel.AbstractAttribute;
import org.hibernate.jpa.internal.metamodel.AbstractManagedType;
import org.hibernate.mapping.Property;

public abstract class PluralAttributeImpl<X, C, E>
extends AbstractAttribute<X, C>
implements PluralAttribute<X, C, E>,
Serializable {
    private final Type<E> elementType;

    private PluralAttributeImpl(Builder<X, C, E, ?> builder) {
        super(((Builder)builder).property.getName(), ((Builder)builder).collectionClass, ((Builder)builder).type, ((Builder)builder).member, ((Builder)builder).persistentAttributeType);
        this.elementType = ((Builder)builder).attributeType;
    }

    public static <X, C, E, K> Builder<X, C, E, K> create(AbstractManagedType<X> ownerType, Type<E> attrType, Class<C> collectionClass, Type<K> keyType) {
        return new Builder(ownerType, attrType, collectionClass, keyType);
    }

    public Type<E> getElementType() {
        return this.elementType;
    }

    public boolean isAssociation() {
        return true;
    }

    public boolean isCollection() {
        return true;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.PLURAL_ATTRIBUTE;
    }

    public Class<E> getBindableJavaType() {
        return this.elementType.getJavaType();
    }

    static class MapAttributeImpl<X, K, V>
    extends PluralAttributeImpl<X, Map<K, V>, V>
    implements MapAttribute<X, K, V> {
        private final Type<K> keyType;

        MapAttributeImpl(Builder<X, Map<K, V>, V, K> xceBuilder) {
            super(xceBuilder);
            this.keyType = ((Builder)xceBuilder).keyType;
        }

        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.MAP;
        }

        public Class<K> getKeyJavaType() {
            return this.keyType.getJavaType();
        }

        public Type<K> getKeyType() {
            return this.keyType;
        }
    }

    static class ListAttributeImpl<X, E>
    extends PluralAttributeImpl<X, List<E>, E>
    implements ListAttribute<X, E> {
        ListAttributeImpl(Builder<X, List<E>, E, ?> xceBuilder) {
            super(xceBuilder);
        }

        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.LIST;
        }
    }

    static class CollectionAttributeImpl<X, E>
    extends PluralAttributeImpl<X, Collection<E>, E>
    implements CollectionAttribute<X, E> {
        CollectionAttributeImpl(Builder<X, Collection<E>, E, ?> xceBuilder) {
            super(xceBuilder);
        }

        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.COLLECTION;
        }
    }

    static class SetAttributeImpl<X, E>
    extends PluralAttributeImpl<X, Set<E>, E>
    implements SetAttribute<X, E> {
        SetAttributeImpl(Builder<X, Set<E>, E, ?> xceBuilder) {
            super(xceBuilder);
        }

        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.SET;
        }
    }

    public static class Builder<X, C, E, K> {
        private final Type<E> attributeType;
        private final AbstractManagedType<X> type;
        private Member member;
        private Attribute.PersistentAttributeType persistentAttributeType;
        private Property property;
        private Class<C> collectionClass;
        private Type<K> keyType;

        private Builder(AbstractManagedType<X> ownerType, Type<E> attrType, Class<C> collectionClass, Type<K> keyType) {
            this.type = ownerType;
            this.attributeType = attrType;
            this.collectionClass = collectionClass;
            this.keyType = keyType;
        }

        public Builder<X, C, E, K> member(Member member) {
            this.member = member;
            return this;
        }

        public Builder<X, C, E, K> property(Property property) {
            this.property = property;
            return this;
        }

        public Builder<X, C, E, K> persistentAttributeType(Attribute.PersistentAttributeType attrType) {
            this.persistentAttributeType = attrType;
            return this;
        }

        public <K> PluralAttributeImpl<X, C, E> build() {
            if (Map.class.equals(this.collectionClass)) {
                Builder builder = this;
                return new MapAttributeImpl(builder);
            }
            if (Set.class.equals(this.collectionClass)) {
                Builder builder = this;
                return new SetAttributeImpl(builder);
            }
            if (List.class.equals(this.collectionClass)) {
                Builder builder = this;
                return new ListAttributeImpl(builder);
            }
            if (Collection.class.equals(this.collectionClass)) {
                Builder builder = this;
                return new CollectionAttributeImpl(builder);
            }
            if (Map.class.isAssignableFrom(this.collectionClass)) {
                Builder builder = this;
                return new MapAttributeImpl(builder);
            }
            if (Set.class.isAssignableFrom(this.collectionClass)) {
                Builder builder = this;
                return new SetAttributeImpl(builder);
            }
            if (List.class.isAssignableFrom(this.collectionClass)) {
                Builder builder = this;
                return new ListAttributeImpl(builder);
            }
            if (Collection.class.isAssignableFrom(this.collectionClass)) {
                Builder builder = this;
                return new CollectionAttributeImpl(builder);
            }
            throw new UnsupportedOperationException("Unkown collection: " + this.collectionClass);
        }
    }
}

