/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.settings.impl.translation.ElasticsearchAnalyzerDefinitionTranslator;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneClassElasticsearchAnalyzerReference
extends ElasticsearchAnalyzerReference {
    private static final Log LOG = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private final Class<?> luceneClass;
    private String name;

    public LuceneClassElasticsearchAnalyzerReference(Class<?> luceneClass) {
        this.luceneClass = luceneClass;
        this.name = null;
    }

    public String getAnalyzerName(String fieldName) {
        if (this.name == null) {
            throw LOG.lazyRemoteAnalyzerReferenceNotInitialized((RemoteAnalyzerReference)this);
        }
        return this.name;
    }

    public boolean isNormalizer(String fieldName) {
        return false;
    }

    @Override
    public void registerDefinitions(String fieldName, ElasticsearchAnalysisDefinitionRegistry definitionRegistry) {
    }

    @Override
    public boolean isInitialized() {
        return this.name != null;
    }

    @Override
    public void initialize(ElasticsearchAnalysisDefinitionRegistry definitionRegistry, ElasticsearchAnalyzerDefinitionTranslator translator) {
        if (this.name != null) {
            throw new AssertionFailure("A Lucene class analyzer reference has been initialized more than once: " + (Object)((Object)this));
        }
        this.name = translator.translate(this.luceneClass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append("<");
        sb.append(this.luceneClass);
        sb.append(",");
        sb.append(this.name);
        sb.append(">");
        return sb.toString();
    }
}

