/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.gson.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.exception.AssertionFailure;

public abstract class JsonElementType<T> {
    public static final JsonElementType<JsonObject> OBJECT = new JsonElementType<JsonObject>(){

        @Override
        protected JsonObject nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : element.getAsJsonObject();
        }

        @Override
        protected JsonElement nullUnsafeToElement(JsonObject value) {
            return value;
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonObject();
        }

        public String toString() {
            return JsonObject.class.getSimpleName();
        }
    };
    public static final JsonElementType<JsonArray> ARRAY = new JsonElementType<JsonArray>(){

        @Override
        protected JsonArray nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : element.getAsJsonArray();
        }

        @Override
        protected JsonElement nullUnsafeToElement(JsonArray value) {
            return value;
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonArray();
        }

        public String toString() {
            return JsonArray.class.getSimpleName();
        }
    };
    public static final JsonElementType<JsonPrimitive> PRIMITIVE = new JsonElementType<JsonPrimitive>(){

        @Override
        protected JsonPrimitive nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : element.getAsJsonPrimitive();
        }

        @Override
        protected JsonElement nullUnsafeToElement(JsonPrimitive value) {
            return value;
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonPrimitive();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName();
        }
    };
    public static final JsonElementType<String> STRING = new JsonElementType<String>(){

        @Override
        protected String nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : element.getAsJsonPrimitive().getAsString();
        }

        @Override
        protected JsonElement nullUnsafeToElement(String value) {
            return new JsonPrimitive(value);
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonPrimitive() && element.getAsJsonPrimitive().isString();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(String)";
        }
    };
    public static final JsonElementType<Boolean> BOOLEAN = new JsonElementType<Boolean>(){

        @Override
        protected Boolean nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : Boolean.valueOf(element.getAsJsonPrimitive().getAsBoolean());
        }

        @Override
        protected JsonElement nullUnsafeToElement(Boolean value) {
            return new JsonPrimitive(value);
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Boolean)";
        }
    };
    public static final JsonElementType<Integer> INTEGER = new JsonNumberType<Integer>(){

        @Override
        protected Integer nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsInt();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Integer)";
        }
    };
    public static final JsonElementType<Long> LONG = new JsonNumberType<Long>(){

        @Override
        protected Long nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsLong();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Long)";
        }
    };
    public static final JsonElementType<Float> FLOAT = new JsonNumberType<Float>(){

        @Override
        protected Float nullUnsafeFromNumber(JsonPrimitive primitive) {
            return Float.valueOf(primitive.getAsFloat());
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Float)";
        }
    };
    public static final JsonElementType<Double> DOUBLE = new JsonNumberType<Double>(){

        @Override
        protected Double nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsDouble();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Double)";
        }
    };
    public static final JsonElementType<JsonNull> NULL = new JsonElementType<JsonNull>(){

        @Override
        protected JsonNull nullUnsafeFromElement(JsonElement element) {
            return element.getAsJsonNull();
        }

        @Override
        protected JsonElement nullUnsafeToElement(JsonNull element) {
            return element;
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonNull();
        }

        public String toString() {
            return JsonNull.class.getSimpleName();
        }
    };

    private JsonElementType() {
    }

    public final T fromElement(JsonElement element) {
        if (element == null) {
            return null;
        }
        if (this.isInstance(element)) {
            return this.nullUnsafeFromElement(element);
        }
        throw new AssertionFailure(element + " cannot be cast to " + this);
    }

    protected abstract T nullUnsafeFromElement(JsonElement var1);

    public final JsonElement toElement(T value) {
        if (value == null) {
            return null;
        }
        return this.nullUnsafeToElement(value);
    }

    protected abstract JsonElement nullUnsafeToElement(T var1);

    public final boolean isInstance(JsonElement element) {
        return element == null ? false : this.nullUnsafeIsInstance(element);
    }

    protected abstract boolean nullUnsafeIsInstance(JsonElement var1);

    private static abstract class JsonNumberType<T extends Number>
    extends JsonElementType<T> {
        private JsonNumberType() {
        }

        @Override
        protected T nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : (T)this.nullUnsafeFromNumber(element.getAsJsonPrimitive());
        }

        protected abstract T nullUnsafeFromNumber(JsonPrimitive var1);

        @Override
        protected JsonElement nullUnsafeToElement(T value) {
            return new JsonPrimitive(value);
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber();
        }
    }
}

