/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public abstract class MetaDataProviderKeyedByClassName
implements MetaDataProvider {
    protected final ConstraintHelper constraintHelper;
    private final Map<String, BeanConfiguration<?>> configuredBeans;

    public MetaDataProviderKeyedByClassName(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
        this.configuredBeans = CollectionHelper.newHashMap();
    }

    @Override
    public <T> List<BeanConfiguration<? super T>> getBeanConfigurationForHierarchy(Class<T> beanClass) {
        ArrayList<BeanConfiguration<T>> configurations = CollectionHelper.newArrayList();
        for (Class<?> oneHierarchyClass : ReflectionHelper.computeClassHierarchy(beanClass, true)) {
            BeanConfiguration<?> configuration = this.getBeanConfiguration(oneHierarchyClass);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }

    protected void addBeanConfiguration(Class<?> beanClass, BeanConfiguration<?> beanConfiguration) {
        this.configuredBeans.put(beanClass.getName(), beanConfiguration);
    }

    protected BeanConfiguration<?> getBeanConfiguration(Class<?> beanClass) {
        Contracts.assertNotNull(beanClass);
        return this.configuredBeans.get(beanClass.getName());
    }

    protected <T> BeanConfiguration<T> createBeanConfiguration(ConfigurationSource source, Class<T> beanClass, Set<? extends ConstrainedElement> constrainableElements, List<Class<?>> defaultGroupSequence, DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider) {
        return new BeanConfiguration<T>(source, beanClass, constrainableElements, defaultGroupSequence, defaultGroupSequenceProvider);
    }
}

