/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tck.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.hibernate.tck.config.ResourceLoadingException;
import org.hibernate.tck.config.SimpleResourceLoader;

public class RuntimeProperties {
    public static final String RESOURCE_BUNDLE = "META-INF/tck-unit.properties";
    private SimpleResourceLoader resourceLoader = new SimpleResourceLoader();

    public List<String> getPropertyValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        this.addPropertiesFromSystem(key, values);
        this.addPropertiesFromResourceBundle(key, values);
        return values;
    }

    private void addPropertiesFromSystem(String key, List<String> values) {
        this.addProperty(key, System.getProperty(key), values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertiesFromResourceBundle(String key, List<String> values) {
        try {
            for (URL url : this.resourceLoader.getResources(RESOURCE_BUNDLE)) {
                Properties properties = new Properties();
                InputStream propertyStream = url.openStream();
                try {
                    properties.load(propertyStream);
                    this.addProperty(key, properties.getProperty(key), values);
                }
                finally {
                    if (propertyStream == null) continue;
                    propertyStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addProperty(String key, String value, List<String> values) {
        if (value != null) {
            values.add(value);
        }
    }

    public <T> Set<Class<T>> getClasses(String propertyName, Class<T> expectedType) {
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        for (String className : this.getPropertyValues(propertyName)) {
            try {
                classes.add(this.resourceLoader.classForName(className));
            }
            catch (ResourceLoadingException e) {}
        }
        return classes;
    }

    public <T> Class<T> getClassValue(String propertyName, Class<T> expectedType, boolean required) {
        Set<Class<T>> classes = this.getClasses(propertyName, expectedType);
        if (classes.size() == 0) {
            if (required) {
                throw new IllegalArgumentException("Cannot find any implementations of " + expectedType.getSimpleName() + ", check that " + propertyName + " is specified");
            }
            return null;
        }
        if (classes.size() > 1) {
            throw new IllegalArgumentException("More than one implementation of " + expectedType.getSimpleName() + " specified by " + propertyName + ", not sure which one to use!");
        }
        return classes.iterator().next();
    }

    public <T> T getInstanceValue(String propertyName, Class<T> expectedType, boolean required) {
        Class<T> clazz = this.getClassValue(propertyName, expectedType, required);
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Error instantiating " + clazz + " specified by " + propertyName, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Error instantiating " + clazz + " specified by " + propertyName, e);
            }
        }
        return null;
    }

    public boolean getBooleanValue(String propertyName, boolean _default, boolean required) {
        return Boolean.valueOf(this.getStringValue(propertyName, _default ? "true" : "false", required));
    }

    public int getIntValue(String propertyName, int _default, boolean required) {
        return Integer.valueOf(this.getStringValue(propertyName, Integer.toString(_default), required));
    }

    public String getStringValue(String propertyName, String _default, boolean required) {
        List<String> values = this.getPropertyValues(propertyName);
        if (values.size() == 0) {
            if (required) {
                throw new IllegalArgumentException("Cannot find required property " + propertyName + ", check that it is specified");
            }
            return _default;
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException("More than one value given for " + propertyName + ", not sure which one to use!");
        }
        return values.iterator().next();
    }
}

