/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.metadata.GroupConversionDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.GroupConversionHelper;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.StringHelper;

public class CascadingMetaData {
    private final Type enclosingType;
    private final TypeVariable<?> typeParameter;
    private final Class<?> declaredContainerClass;
    private final TypeVariable<?> declaredTypeParameter;
    private final List<CascadingMetaData> containerElementTypesCascadingMetaData;
    private final boolean cascading;
    private GroupConversionHelper groupConversionHelper;
    private final boolean markedForCascadingOnElementOrContainerElements;
    private final boolean hasGroupConversionsOnElementOrContainerElements;

    public CascadingMetaData(CascadingTypeParameter cascadingMetaData) {
        this.enclosingType = cascadingMetaData.getEnclosingType();
        this.typeParameter = cascadingMetaData.getTypeParameter();
        this.declaredContainerClass = cascadingMetaData.getDeclaredContainerClass();
        this.declaredTypeParameter = cascadingMetaData.getDeclaredTypeParameter();
        this.containerElementTypesCascadingMetaData = cascadingMetaData.getContainerElementTypesCascadingMetaData().entrySet().stream().map(entry -> new CascadingMetaData((CascadingTypeParameter)entry.getValue())).collect(Collectors.collectingAndThen(Collectors.toList(), CollectionHelper::toImmutableList));
        this.groupConversionHelper = new GroupConversionHelper(cascadingMetaData.getGroupConversions());
        this.cascading = cascadingMetaData.isCascading();
        this.markedForCascadingOnElementOrContainerElements = cascadingMetaData.isMarkedForCascadingOnElementOrContainerElements();
        this.hasGroupConversionsOnElementOrContainerElements = cascadingMetaData.isMarkedForCascadingOnElementOrContainerElements();
    }

    public TypeVariable<?> getTypeParameter() {
        return this.typeParameter;
    }

    public Type getEnclosingType() {
        return this.enclosingType;
    }

    public Class<?> getDeclaredContainerClass() {
        return this.declaredContainerClass;
    }

    public TypeVariable<?> getDeclaredTypeParameter() {
        return this.declaredTypeParameter;
    }

    public boolean isCascading() {
        return this.cascading;
    }

    public boolean isMarkedForCascadingOnElementOrContainerElements() {
        return this.markedForCascadingOnElementOrContainerElements;
    }

    public boolean hasGroupConversionsOnElementOrContainerElements() {
        return this.hasGroupConversionsOnElementOrContainerElements;
    }

    public List<CascadingMetaData> getContainerElementTypesCascadingMetaData() {
        return this.containerElementTypesCascadingMetaData;
    }

    public Class<?> convertGroup(Class<?> originalGroup) {
        return this.groupConversionHelper.convertGroup(originalGroup);
    }

    public Set<GroupConversionDescriptor> getGroupConversionDescriptors() {
        return this.groupConversionHelper.asDescriptors();
    }

    public void validateGroupConversions(String context) {
        this.groupConversionHelper.validateGroupConversions(this.cascading, context);
        for (CascadingMetaData cascadingMetaData : this.containerElementTypesCascadingMetaData) {
            cascadingMetaData.validateGroupConversions(context);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append("enclosingType=").append(StringHelper.toShortString(this.enclosingType)).append(", ");
        sb.append("typeParameter=").append(this.typeParameter).append(", ");
        sb.append("cascading=").append(this.cascading).append(", ");
        sb.append("groupConversions=").append(this.groupConversionHelper).append(", ");
        sb.append("containerElementTypesCascadingMetaData=").append(this.containerElementTypesCascadingMetaData);
        sb.append("]");
        return sb.toString();
    }
}

