/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.validator.HibernateValidatorPermission;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.aggregated.CascadingMetaData;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.SetAccessibility;

public class GetterCascadable
implements Cascadable {
    private final Method method;
    private final String propertyName;
    private final Type cascadableType;
    private final CascadingMetaData cascadingMetaData;

    GetterCascadable(Method method, CascadingMetaData cascadingMetaData) {
        this.method = method;
        this.propertyName = ReflectionHelper.getPropertyName(method);
        this.cascadableType = ReflectionHelper.typeOf(method);
        this.cascadingMetaData = cascadingMetaData;
        this.cascadingMetaData.validateGroupConversions(method.toString());
    }

    @Override
    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    @Override
    public Type getCascadableType() {
        return this.cascadableType;
    }

    @Override
    public Object getValue(Object parent) {
        return ReflectionHelper.getValue(this.method, parent);
    }

    @Override
    public void appendTo(PathImpl path) {
        path.addPropertyNode(this.propertyName);
    }

    @Override
    public CascadingMetaData getCascadingMetaData() {
        return this.cascadingMetaData;
    }

    public static class Builder
    implements Cascadable.Builder {
        private final Method method;
        private CascadingTypeParameter cascadingMetaData;

        public Builder(Method method, CascadingTypeParameter cascadingMetaData) {
            this.method = method;
            this.cascadingMetaData = cascadingMetaData;
        }

        @Override
        public void mergeCascadingMetaData(CascadingTypeParameter cascadingMetaData) {
            this.cascadingMetaData = this.cascadingMetaData.merge(cascadingMetaData);
        }

        @Override
        public GetterCascadable build() {
            return new GetterCascadable(this.getAccessible(this.method), new CascadingMetaData(this.cascadingMetaData));
        }

        private Method getAccessible(Method original) {
            if (original.isAccessible()) {
                return original;
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(HibernateValidatorPermission.ACCESS_PRIVATE_MEMBERS);
            }
            Class<?> clazz = original.getDeclaringClass();
            Method member = this.run(GetDeclaredMethod.action(clazz, original.getName(), new Class[0]));
            this.run(SetAccessibility.action(member));
            return member;
        }

        private <T> T run(PrivilegedAction<T> action) {
            return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        }
    }
}

