/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.privilegedactions;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class GetAnnotationParameter<T>
implements PrivilegedAction<T> {
    private static final Log log = LoggerFactory.make();
    private final Annotation annotation;
    private final String parameterName;
    private final Class<T> type;

    public static <T> GetAnnotationParameter<T> action(Annotation annotation, String parameterName, Class<T> type) {
        return new GetAnnotationParameter<T>(annotation, parameterName, type);
    }

    private GetAnnotationParameter(Annotation annotation, String parameterName, Class<T> type) {
        this.annotation = annotation;
        this.parameterName = parameterName;
        this.type = type;
    }

    @Override
    public T run() {
        try {
            Method m = this.annotation.getClass().getMethod(this.parameterName, new Class[0]);
            m.setAccessible(true);
            Object o = m.invoke((Object)this.annotation, new Object[0]);
            if (this.type.isAssignableFrom(o.getClass())) {
                return (T)o;
            }
            throw log.getWrongParameterTypeException(this.type, o.getClass());
        }
        catch (NoSuchMethodException e) {
            throw log.getUnableToFindAnnotationParameterException(this.parameterName, e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw log.getUnableToGetAnnotationParameterException(this.parameterName, this.annotation.getClass(), e);
        }
    }
}

