/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.persist.CachedObject;

public class TransactionManager2PL
extends TransactionManagerCommon
implements TransactionManager {
    public TransactionManager2PL(Database database) {
        this.database = database;
        this.hasPersistence = this.database.logger.isLogged();
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 0;
    }

    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    public boolean isMVRows() {
        return false;
    }

    public int getTransactionControl() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionControl(Session session, int n) {
        this.writeLock.lock();
        try {
            switch (n) {
                case 2: {
                    TransactionManagerMVCC transactionManagerMVCC = new TransactionManagerMVCC(this.database);
                    transactionManagerMVCC.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
                    transactionManagerMVCC.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    this.database.txManager = transactionManagerMVCC;
                    break;
                }
                case 1: {
                    TransactionManagerMV2PL transactionManagerMV2PL = new TransactionManagerMV2PL(this.database);
                    transactionManagerMV2PL.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
                    transactionManagerMV2PL.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    this.database.txManager = transactionManagerMV2PL;
                    break;
                }
            }
            Object var5_5 = null;
            this.writeLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    public boolean prepareCommitActions(Session session) {
        session.actionTimestamp = this.nextChangeTimestamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int n = session.rowActionList.size();
        Object[] objectArray = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            this.endTransaction(session);
            session.actionTimestamp = this.nextChangeTimestamp();
            for (int i = 0; i < n; ++i) {
                RowAction rowAction = (RowAction)objectArray[i];
                rowAction.commit(session);
            }
            this.persistCommit(session, objectArray, n);
            this.endTransactionTPL(session);
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        session.tempSet.clear();
        if (session != this.lobSession && this.lobSession.rowActionList.size() > 0) {
            this.lobSession.isTransaction = true;
            this.lobSession.actionIndex = this.lobSession.rowActionList.size();
            this.lobSession.commit(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Session session) {
        session.abortTransaction = false;
        session.actionTimestamp = this.nextChangeTimestamp();
        this.rollbackPartial(session, 0, session.transactionTimestamp);
        this.endTransaction(session);
        this.writeLock.lock();
        try {
            this.endTransactionTPL(session);
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = (Integer)session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
        this.endActionTPL(session);
    }

    void rollbackPartial(Session session, int n, long l) {
        Object[] objectArray = session.rowActionList.getArray();
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n2 - 1; i >= n; --i) {
            RowAction rowAction = (RowAction)objectArray[i];
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            rowAction.rollback(session, l);
            int n3 = rowAction.mergeRollback(session, l, row);
            rowAction.store.rollbackRow(session, row, n3, this.txModel);
        }
        session.rowActionList.setSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowAction addDeleteAction(Session session, Table table, Row row, int[] nArray) {
        RowAction rowAction;
        Object object = row;
        synchronized (object) {
            rowAction = RowAction.addDeleteAction(session, table, row, nArray);
        }
        session.rowActionList.add(rowAction);
        object = session.sessionData.getRowStore(table);
        object.delete(session, row);
        return rowAction;
    }

    public void addInsertAction(Session session, Table table, Row row) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        session.rowActionList.add(rowAction);
    }

    public boolean canRead(Session session, Row row, int n, int[] nArray) {
        return true;
    }

    public boolean canRead(Session session, int n, int n2) {
        return true;
    }

    public void setTransactionInfo(CachedObject cachedObject) {
    }

    public void removeTransactionInfo(CachedObject cachedObject) {
    }

    public void beginTransaction(Session session) {
        session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
        session.isTransaction = true;
        ++this.transactionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAction(Session session, Statement statement) {
        if (session.hasLocks(statement)) {
            return;
        }
        this.writeLock.lock();
        try {
            boolean bl = this.setWaitedSessionsTPL(session, statement);
            if (bl) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, statement);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            }
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void beginActionResume(Session session) {
        session.actionTimestamp = this.nextChangeTimestamp();
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp;
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    void endTransaction(Session session) {
        session.isTransaction = false;
        --this.transactionCount;
    }

    public DoubleIntIndex getTransactionIDList() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(10, false);
        return doubleIntIndex;
    }

    public void convertTransactionIDs(DoubleIntIndex doubleIntIndex) {
    }
}

