/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.transport.Address;

public class PersistentUUID
implements Address {
    final UUID uuid;
    final int hashCode;

    private PersistentUUID(UUID uuid) {
        this.uuid = uuid;
        this.hashCode = uuid.hashCode();
    }

    public PersistentUUID(long msb, long lsb) {
        this(new UUID(msb, lsb));
    }

    public static PersistentUUID randomUUID() {
        return new PersistentUUID(Util.threadLocalRandomUUID());
    }

    public static PersistentUUID fromString(String name) {
        return new PersistentUUID(UUID.fromString(name));
    }

    public long getMostSignificantBits() {
        return this.uuid.getMostSignificantBits();
    }

    public long getLeastSignificantBits() {
        return this.uuid.getLeastSignificantBits();
    }

    @Override
    public int compareTo(Address o) {
        PersistentUUID other = (PersistentUUID)o;
        return this.uuid.compareTo(other.uuid);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.uuid.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentUUID other = (PersistentUUID)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public static class Externalizer
    extends AbstractExternalizer<PersistentUUID> {
        public Set<Class<? extends PersistentUUID>> getTypeClasses() {
            return Collections.singleton(PersistentUUID.class);
        }

        public void writeObject(ObjectOutput output, PersistentUUID uuid) throws IOException {
            output.writeLong(uuid.getMostSignificantBits());
            output.writeLong(uuid.getLeastSignificantBits());
        }

        public PersistentUUID readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new PersistentUUID(input.readLong(), input.readLong());
        }

        public Integer getId() {
            return 97;
        }
    }
}

