/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.generic.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.generic.remote.RemoteAddressCredential;
import org.jasig.cas.authentication.AbstractAuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteAddressAuthenticationHandler
extends AbstractAuthenticationHandler {
    private static final int HEX_RIGHT_SHIFT_COEFFICIENT = 255;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private InetAddress inetNetmask;
    @NotNull
    private InetAddress inetNetwork;

    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException {
        RemoteAddressCredential c = (RemoteAddressCredential)credential;
        try {
            InetAddress inetAddress = InetAddress.getByName(c.getRemoteAddress().trim());
            if (this.containsAddress(this.inetNetwork, this.inetNetmask, inetAddress)) {
                return new DefaultHandlerResult((AuthenticationHandler)this, (CredentialMetaData)c, this.principalFactory.createPrincipal(c.getId()));
            }
        }
        catch (UnknownHostException e) {
            this.logger.debug("Unknown host {}", (Object)c.getRemoteAddress());
        }
        throw new FailedLoginException(c.getRemoteAddress() + " not in allowed range.");
    }

    public boolean supports(Credential credential) {
        return credential instanceof RemoteAddressCredential;
    }

    private boolean containsAddress(InetAddress network, InetAddress netmask, InetAddress ip) {
        this.logger.debug("Checking IP address: {} in {} by {}", new Object[]{ip, network, netmask});
        byte[] networkBytes = network.getAddress();
        byte[] netmaskBytes = netmask.getAddress();
        byte[] ipBytes = ip.getAddress();
        if (networkBytes.length != netmaskBytes.length || netmaskBytes.length != ipBytes.length) {
            this.logger.debug("Network address {}, subnet mask {} and/or host address {} have different sizes! (return false ...)", new Object[]{network, netmask, ip});
            return false;
        }
        for (int i = 0; i < netmaskBytes.length; ++i) {
            int mask = netmaskBytes[i] & 0xFF;
            if ((networkBytes[i] & mask) == (ipBytes[i] & mask)) continue;
            this.logger.debug("{} is not in {}/{}", new Object[]{ip, network, netmask});
            return false;
        }
        this.logger.debug("{} is in {}/{}", new Object[]{ip, network, netmask});
        return true;
    }

    public void setIpNetworkRange(String ipAddressRange) {
        String[] splitAddress;
        if (ipAddressRange != null && (splitAddress = ipAddressRange.split("/")).length == 2) {
            String network = splitAddress[0].trim();
            String netmask = splitAddress[1].trim();
            try {
                this.inetNetwork = InetAddress.getByName(network);
                this.logger.debug("InetAddress network: {}", (Object)this.inetNetwork.toString());
            }
            catch (UnknownHostException e) {
                this.logger.error("The network address was not valid: {}", (Object)e.getMessage());
            }
            try {
                this.inetNetmask = InetAddress.getByName(netmask);
                this.logger.debug("InetAddress netmask: {}", (Object)this.inetNetmask.toString());
            }
            catch (UnknownHostException e) {
                this.logger.error("The network netmask was not valid: {}", (Object)e.getMessage());
            }
        }
    }
}

