/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class BindModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    protected final Principal authenticateUsernamePasswordInternal(String username, String password) throws GeneralSecurityException, PreventedException {
        try {
            Connection c = this.getDataSource().getConnection(username, password);
            DataSourceUtils.releaseConnection((Connection)c, (DataSource)this.getDataSource());
            return new SimplePrincipal(username);
        }
        catch (SQLException e) {
            throw new FailedLoginException(e.getMessage());
        }
        catch (Exception e) {
            throw new PreventedException("Unexpected SQL connection error", (Throwable)e);
        }
    }
}

