/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbc4;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.javasimon.Split;
import org.javasimon.jdbc4.SimonResultSet;
import org.javasimon.jdbc4.SimonStatement;
import org.javasimon.jdbc4.SqlNormalizer;

public class SimonPreparedStatement
extends SimonStatement
implements PreparedStatement {
    protected String sql;
    private PreparedStatement stmt;

    SimonPreparedStatement(Connection conn, PreparedStatement stmt, String sql, String prefix) {
        super(conn, stmt, prefix);
        this.stmt = stmt;
        this.sql = sql;
    }

    private Split prepare() {
        if (this.sql != null && !this.sql.equals("")) {
            this.sqlNormalizer = new SqlNormalizer(this.sql);
            this.sqlCmdLabel = this.prefix + ".sql." + this.sqlNormalizer.getType();
            return this.startSplit();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ResultSet executeQuery() throws SQLException {
        Split split = this.prepare();
        try {
            SimonResultSet simonResultSet = new SimonResultSet(this.stmt.executeQuery(), this, this.prefix, split.getStopwatch().getName());
            return simonResultSet;
        }
        finally {
            this.finish(split);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int executeUpdate() throws SQLException {
        Split split = this.prepare();
        try {
            int n = this.stmt.executeUpdate();
            return n;
        }
        finally {
            this.finish(split);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean execute() throws SQLException {
        Split split = this.prepare();
        try {
            boolean bl = this.stmt.execute();
            return bl;
        }
        finally {
            this.finish(split);
        }
    }

    @Override
    public final void addBatch() throws SQLException {
        this.batchSql.add(this.sql);
        this.stmt.addBatch();
    }

    @Override
    public final void setNull(int i, int i1) throws SQLException {
        this.stmt.setNull(i, i1);
    }

    @Override
    public final void setBoolean(int i, boolean b) throws SQLException {
        this.stmt.setBoolean(i, b);
    }

    @Override
    public final void setByte(int i, byte b) throws SQLException {
        this.stmt.setByte(i, b);
    }

    @Override
    public final void setShort(int i, short i1) throws SQLException {
        this.stmt.setShort(i, i1);
    }

    @Override
    public final void setInt(int i, int i1) throws SQLException {
        this.stmt.setInt(i, i1);
    }

    @Override
    public final void setLong(int i, long l) throws SQLException {
        this.stmt.setLong(i, l);
    }

    @Override
    public final void setFloat(int i, float v) throws SQLException {
        this.stmt.setFloat(i, v);
    }

    @Override
    public final void setDouble(int i, double v) throws SQLException {
        this.stmt.setDouble(i, v);
    }

    @Override
    public final void setBigDecimal(int i, BigDecimal bigDecimal) throws SQLException {
        this.stmt.setBigDecimal(i, bigDecimal);
    }

    @Override
    public final void setString(int i, String s) throws SQLException {
        this.stmt.setString(i, s);
    }

    @Override
    public final void setBytes(int i, byte[] bytes) throws SQLException {
        this.stmt.setBytes(i, bytes);
    }

    @Override
    public final void setDate(int i, Date date) throws SQLException {
        this.stmt.setDate(i, date);
    }

    @Override
    public final void setTime(int i, Time time) throws SQLException {
        this.stmt.setTime(i, time);
    }

    @Override
    public final void setTimestamp(int i, Timestamp timestamp) throws SQLException {
        this.stmt.setTimestamp(i, timestamp);
    }

    @Override
    public final void setAsciiStream(int i, InputStream inputStream, int i1) throws SQLException {
        this.stmt.setAsciiStream(i, inputStream, i1);
    }

    @Override
    @Deprecated
    public final void setUnicodeStream(int i, InputStream inputStream, int i1) throws SQLException {
        this.stmt.setUnicodeStream(i, inputStream, i1);
    }

    @Override
    public final void setBinaryStream(int i, InputStream inputStream, int i1) throws SQLException {
        this.stmt.setBinaryStream(i, inputStream, i1);
    }

    @Override
    public final void clearParameters() throws SQLException {
        this.stmt.clearParameters();
    }

    @Override
    public final void setObject(int i, Object o, int i1) throws SQLException {
        this.stmt.setObject(i, o, i1);
    }

    @Override
    public final void setObject(int i, Object o) throws SQLException {
        this.stmt.setObject(i, o);
    }

    @Override
    public final void setObject(int i, Object o, int i1, int i2) throws SQLException {
        this.stmt.setObject(i, o, i1, i2);
    }

    @Override
    public final void setCharacterStream(int i, Reader reader, int i1) throws SQLException {
        this.stmt.setCharacterStream(i, reader, i1);
    }

    @Override
    public final void setRef(int i, Ref ref) throws SQLException {
        this.stmt.setRef(i, ref);
    }

    @Override
    public final void setBlob(int i, Blob blob) throws SQLException {
        this.stmt.setBlob(i, blob);
    }

    @Override
    public final void setClob(int i, Clob clob) throws SQLException {
        this.stmt.setClob(i, clob);
    }

    @Override
    public final void setArray(int i, Array array) throws SQLException {
        this.stmt.setArray(i, array);
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        return this.stmt.getMetaData();
    }

    @Override
    public final void setDate(int i, Date date, Calendar calendar) throws SQLException {
        this.stmt.setDate(i, date, calendar);
    }

    @Override
    public final void setTime(int i, Time time, Calendar calendar) throws SQLException {
        this.stmt.setTime(i, time, calendar);
    }

    @Override
    public final void setTimestamp(int i, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.stmt.setTimestamp(i, timestamp, calendar);
    }

    @Override
    public final void setNull(int i, int i1, String s) throws SQLException {
        this.stmt.setNull(i, i1, s);
    }

    @Override
    public final void setURL(int i, URL url) throws SQLException {
        this.stmt.setURL(i, url);
    }

    @Override
    public final ParameterMetaData getParameterMetaData() throws SQLException {
        return this.stmt.getParameterMetaData();
    }

    @Override
    public final void setRowId(int i, RowId rowId) throws SQLException {
        this.stmt.setRowId(i, rowId);
    }

    @Override
    public final void setNString(int i, String s) throws SQLException {
        this.stmt.setNString(i, s);
    }

    @Override
    public final void setNCharacterStream(int i, Reader reader, long l) throws SQLException {
        this.stmt.setNCharacterStream(i, reader, l);
    }

    @Override
    public final void setNClob(int i, NClob nClob) throws SQLException {
        this.stmt.setNClob(i, nClob);
    }

    @Override
    public final void setClob(int i, Reader reader, long l) throws SQLException {
        this.stmt.setClob(i, reader, l);
    }

    @Override
    public final void setBlob(int i, InputStream inputStream, long l) throws SQLException {
        this.stmt.setBlob(i, inputStream, l);
    }

    @Override
    public final void setNClob(int i, Reader reader, long l) throws SQLException {
        this.stmt.setNClob(i, reader, l);
    }

    @Override
    public final void setSQLXML(int i, SQLXML sqlxml) throws SQLException {
        this.stmt.setSQLXML(i, sqlxml);
    }

    @Override
    public final void setAsciiStream(int i, InputStream inputStream, long l) throws SQLException {
        this.stmt.setAsciiStream(i, inputStream, l);
    }

    @Override
    public final void setBinaryStream(int i, InputStream inputStream, long l) throws SQLException {
        this.stmt.setBinaryStream(i, inputStream);
    }

    @Override
    public final void setCharacterStream(int i, Reader reader, long l) throws SQLException {
        this.stmt.setCharacterStream(i, reader, l);
    }

    @Override
    public final void setAsciiStream(int i, InputStream inputStream) throws SQLException {
        this.stmt.setAsciiStream(i, inputStream);
    }

    @Override
    public final void setBinaryStream(int i, InputStream inputStream) throws SQLException {
        this.stmt.setBinaryStream(i, inputStream);
    }

    @Override
    public final void setCharacterStream(int i, Reader reader) throws SQLException {
        this.stmt.setCharacterStream(i, reader);
    }

    @Override
    public final void setNCharacterStream(int i, Reader reader) throws SQLException {
        this.stmt.setNCharacterStream(i, reader);
    }

    @Override
    public final void setClob(int i, Reader reader) throws SQLException {
        this.stmt.setClob(i, reader);
    }

    @Override
    public final void setBlob(int i, InputStream inputStream) throws SQLException {
        this.stmt.setBlob(i, inputStream);
    }

    @Override
    public final void setNClob(int i, Reader reader) throws SQLException {
        this.stmt.setNClob(i, reader);
    }
}

