/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.spring;

import java.lang.reflect.Method;
import org.javasimon.aop.Monitored;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public final class MonitoredMeasuringPointcut
implements Pointcut {
    public ClassFilter getClassFilter() {
        return ClassFilter.TRUE;
    }

    public MethodMatcher getMethodMatcher() {
        return MonitoredMethodMatcher.INSTANCE;
    }

    private static enum MonitoredMethodMatcher implements MethodMatcher
    {
        INSTANCE;


        public boolean matches(Method method, Class targetClass) {
            return !ClassUtils.isCglibProxyClass((Class)targetClass) && this.isMonitoredAnnotationOnClassOrMethod(method, targetClass);
        }

        private boolean isMonitoredAnnotationOnClassOrMethod(Method method, Class targetClass) {
            return AnnotationUtils.findAnnotation((Class)targetClass, Monitored.class) != null || AnnotationUtils.findAnnotation((Method)AopUtils.getMostSpecificMethod((Method)method, (Class)targetClass), Monitored.class) != null;
        }

        public boolean isRuntime() {
            return false;
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            throw new UnsupportedOperationException("This is not a runtime method matcher");
        }
    }
}

