/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.spring;

import org.aopalliance.intercept.MethodInvocation;
import org.javasimon.Manager;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.source.StopwatchSource;
import org.javasimon.spring.BasicMonitoringInterceptor;
import org.javasimon.spring.SpringStopwatchSource;

public class MonitoringInterceptor
extends BasicMonitoringInterceptor {
    public static final String EXCEPTION_TAG = "failed";
    private boolean tagByExceptionType;

    public MonitoringInterceptor(StopwatchSource<MethodInvocation> stopwatchSource) {
        super(stopwatchSource);
    }

    public MonitoringInterceptor(Manager manager) {
        super((StopwatchSource<MethodInvocation>)new SpringStopwatchSource(manager).cache());
    }

    public MonitoringInterceptor() {
        super((StopwatchSource<MethodInvocation>)new SpringStopwatchSource(SimonManager.manager()).cache());
    }

    public void setTagByExceptionType(boolean tagByExceptionType) {
        this.tagByExceptionType = tagByExceptionType;
    }

    @Override
    protected Object processInvoke(MethodInvocation invocation, Split split) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            split.stop(this.tagByExceptionType ? t.getClass().getSimpleName() : EXCEPTION_TAG);
            throw t;
        }
    }
}

