/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v2;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remotingjmx.protocol.v2.ClientExecutorManager;
import org.jboss.remotingjmx.protocol.v2.ClientRequestManager;
import org.jboss.remotingjmx.protocol.v2.Common;
import org.jboss.remotingjmx.protocol.v2.VersionedIoFuture;
import org.xnio.IoUtils;

abstract class ClientCommon
extends Common {
    private static final Logger log = Logger.getLogger(ClientCommon.class);
    public static final int DEFAULT_TIMEOUT = 60;
    protected final int timeoutSeconds;

    ClientCommon(Channel channel, Map<String, ?> environment) {
        super(channel);
        Integer seconds = null;
        if (environment != null && environment.containsKey("org.jboss.remoting-jmx.timeout")) {
            Object timeout = environment.get("org.jboss.remoting-jmx.timeout");
            if (timeout instanceof Number) {
                seconds = ((Number)timeout).intValue();
            } else if (timeout instanceof String) {
                try {
                    seconds = Integer.parseInt((String)timeout);
                }
                catch (NumberFormatException e) {
                    log.warnf((Throwable)e, "Could not parse configured timeout %s", timeout);
                }
            } else {
                log.warnf("Timeout %s configured via environment is not valid ", timeout);
            }
        } else {
            seconds = Integer.getInteger("org.jboss.remoting-jmx.timeout", 60);
        }
        this.timeoutSeconds = seconds == null ? 60 : seconds;
    }

    protected IOException toIoException(Exception e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException("Unexpected failure", e);
    }

    protected abstract ClientRequestManager getClientRequestManager();

    protected abstract ClientExecutorManager getClientExecutorManager();

    protected class StringResponseHandler
    extends BaseResponseHandler<String> {
        protected StringResponseHandler() {
        }

        @Override
        protected byte getExpectedType() {
            return 8;
        }

        @Override
        protected String readValue(DataInput input) throws IOException {
            return input.readUTF();
        }
    }

    protected class MarshalledResponseHandler<T>
    extends BaseResponseHandler<T> {
        private final byte expectedType;

        protected MarshalledResponseHandler(byte expectedType) {
            this.expectedType = expectedType;
        }

        @Override
        protected byte getExpectedType() {
            return this.expectedType;
        }

        @Override
        protected T readValue(DataInput input) throws IOException {
            Unmarshaller unmarshaller = ClientCommon.this.prepareForUnMarshalling(input);
            try {
                return (T)unmarshaller.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (ClassCastException e) {
                throw new IOException(e);
            }
        }
    }

    protected abstract class BaseResponseHandler<T>
    implements Common.MessageHandler {
        protected BaseResponseHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) {
            VersionedIoFuture future = ClientCommon.this.getClientRequestManager().getFuture(correlationId);
            try {
                TypeExceptionHolder response = new TypeExceptionHolder();
                byte outcome = input.readByte();
                if (outcome == 0) {
                    byte expectedType = this.getExpectedType();
                    if (expectedType != 0) {
                        byte parameterType = input.readByte();
                        if (parameterType != expectedType) {
                            throw new IOException("Unexpected response parameter received.");
                        }
                        response.value = this.readValue(input);
                    }
                } else if (outcome == 1) {
                    byte parameterType = input.readByte();
                    if (parameterType != 3) {
                        throw new IOException("Unexpected response parameter received.");
                    }
                    Unmarshaller unmarshaller = ClientCommon.this.prepareForUnMarshalling(input);
                    response.e = (Exception)unmarshaller.readObject(Exception.class);
                } else {
                    future.setException(new IOException("Outcome not understood"));
                }
                future.setResult(response);
            }
            catch (ClassCastException e) {
                future.setException(new IOException(e));
            }
            catch (ClassNotFoundException e) {
                future.setException(new IOException(e));
            }
            catch (IOException e) {
                future.setException(e);
            }
        }

        protected abstract byte getExpectedType();

        protected abstract T readValue(DataInput var1) throws IOException;
    }

    protected class MessageReceiver
    implements Channel.Receiver {
        protected MessageReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Channel channel, MessageInputStream message) {
            block8: {
                final DataInputStream dis = new DataInputStream((InputStream)message);
                boolean endReceiveLoop = false;
                try {
                    byte messageId = dis.readByte();
                    final int correlationId = dis.readInt();
                    log.tracef("Message Received id(%h), correlationId(%d)", (int)messageId, correlationId);
                    final Common.MessageHandler mh = ClientCommon.this.getHandlerRegistry().get(messageId);
                    if (mh != null) {
                        if (mh instanceof MessageHandler) {
                            endReceiveLoop = ((MessageHandler)mh).endReceiveLoop();
                        }
                        ClientCommon.this.getClientExecutorManager().execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    mh.handle(dis, correlationId);
                                }
                                catch (IOException e) {
                                    log.error((Object)e);
                                }
                                finally {
                                    IoUtils.safeClose((Closeable)dis);
                                }
                            }
                        });
                        break block8;
                    }
                    throw new IOException("Unrecognised Message ID");
                }
                catch (IOException e) {
                    log.error((Object)e);
                    IoUtils.safeClose((Closeable)dis);
                }
                finally {
                    if (!endReceiveLoop) {
                        channel.receiveMessage((Channel.Receiver)this);
                    }
                }
            }
        }

        public void handleError(Channel channel, IOException error) {
            ClientCommon.this.getClientRequestManager().cancelAllRequests(error);
        }

        public void handleEnd(Channel channel) {
            ClientCommon.this.getClientRequestManager().cancelAllRequests(new IOException("Connection Ended"));
        }
    }

    protected static interface MessageHandler
    extends Common.MessageHandler {
        public boolean endReceiveLoop();
    }

    protected class TypeExceptionHolder<T> {
        protected T value;
        protected Exception e;

        protected TypeExceptionHolder() {
        }
    }
}

