/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.TypeParceler;
import kotlinx.android.parcel.WriteWith;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.ParcelableAnnotationChecker;
import org.jetbrains.kotlin.android.parcel.ParcelableResolveExtensionKt;
import org.jetbrains.kotlin.android.synthetic.diagnostic.DefaultErrorMessagesAndroid;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u0010\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0013\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkIfTheContainingClassIsParcelize", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkTypeParcelerUsage", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "checkWriteWithUsage", "Companion", "android-extensions-compiler"})
public final class ParcelableAnnotationChecker
implements CallChecker {
    @NotNull
    private static final FqName TYPE_PARCELER_FQNAME;
    @NotNull
    private static final FqName WRITE_WITH_FQNAME;
    public static final Companion Companion;

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        ClassDescriptor classDescriptor;
        ClassDescriptor it;
        Intrinsics.checkParameterIsNotNull(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        if (!(callableDescriptor instanceof ClassConstructorDescriptor)) {
            callableDescriptor = null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)callableDescriptor;
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        ClassDescriptor classDescriptor2 = it = (classDescriptor = constructorDescriptor.getConstructedClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"it");
        Object object = Intrinsics.areEqual((Object)classDescriptor2.getKind(), (Object)ClassKind.ANNOTATION_CLASS) ? classDescriptor : null;
        if (object == null) {
            return;
        }
        ClassDescriptor annotationClass = object;
        Call call = resolvedCall.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call, (String)"resolvedCall.call");
        KtElement ktElement = call.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"resolvedCall.call.callElement");
        PsiElement $receiver$iv = (PsiElement)ktElement;
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtAnnotationEntry.class, (boolean)false);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        PsiElement $receiver$iv2 = (PsiElement)annotationEntry;
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtModifierListOwner.class, (boolean)true);
        if (ktModifierListOwner == null) {
            return;
        }
        KtModifierListOwner annotationOwner = ktModifierListOwner;
        ClassDescriptor classDescriptor3 = annotationClass;
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"annotationClass");
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor3)), (Object)Companion.getTYPE_PARCELER_FQNAME())) {
            this.checkTypeParcelerUsage(resolvedCall, annotationEntry, context2, annotationOwner);
        }
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)), (Object)Companion.getWRITE_WITH_FQNAME())) {
            this.checkWriteWithUsage(resolvedCall, annotationEntry, context2, annotationOwner);
        }
    }

    private final void checkTypeParcelerUsage(ResolvedCall<?> resolvedCall, KtAnnotationEntry annotationEntry, CallCheckerContext context2, KtModifierListOwner element) {
        PsiElement $receiver$iv;
        int duplicatingAnnotationCount;
        int n;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv2;
        KotlinType kotlinType;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)context2.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)element);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor descriptor = declarationDescriptor;
        Object it = kotlinType = resolvedCall.getTypeArguments().values();
        Object object = it.size() == 2 ? kotlinType : null;
        if (object == null || (object = (KotlinType)CollectionsKt.first((Iterable)((Iterable)object))) == null) {
            return;
        }
        KotlinType thisMappedType = object;
        it = descriptor.getAnnotations().getAllAnnotations();
        void $i$a$1$takeIf = $receiver$iv2;
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            AnnotationWithTarget it2 = (AnnotationWithTarget)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it2.getAnnotation().getFqName(), (Object)Companion.getTYPE_PARCELER_FQNAME())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KotlinType kotlinType2;
            Object element$iv$iv = element$iv$iv$iv;
            AnnotationWithTarget it3 = (AnnotationWithTarget)element$iv$iv;
            List $i$f$filter = it3.getAnnotation().getType().getArguments();
            List it4 = $i$f$filter;
            List list = it4.size() == 2 ? $i$f$filter : null;
            KotlinType kotlinType3 = list != null && (list = (TypeProjection)CollectionsKt.first((List)list)) != null ? list.getType() : null;
            if (kotlinType3 == null) continue;
            KotlinType it$iv$iv = kotlinType2 = kotlinType3;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $receiver$iv2) {
                KotlinType it5 = (KotlinType)element$iv;
                if (!Intrinsics.areEqual((Object)it5, (Object)thisMappedType)) continue;
                ++count$iv;
            }
            n = duplicatingAnnotationCount = count$iv;
        }
        if (duplicatingAnnotationCount > 1) {
            List list = annotationEntry.getTypeArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"annotationEntry.typeArguments");
            KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.firstOrNull((List)list);
            KtElementImplStub reportElement = ktTypeProjection != null ? (KtElementImplStub)ktTypeProjection : (KtElementImplStub)annotationEntry;
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)context2.getTrace()), (Diagnostic)((Diagnostic)ErrorsAndroid.DUPLICATING_TYPE_PARCELERS.on((PsiElement)reportElement)), (DefaultErrorMessages.Extension)DefaultErrorMessagesAndroid.INSTANCE);
            return;
        }
        KtModifierListOwner count$iv = element;
        KtClassOrObject containingClass = count$iv instanceof KtClassOrObject ? (KtClassOrObject)element : (count$iv instanceof KtParameter ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element)) : null);
        this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry, context2);
        if (element instanceof KtParameter && PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = (PsiElement)element), KtDeclaration.class, (boolean)true) instanceof KtPrimaryConstructor) {
            ClassDescriptor containingClassDescriptor = (ClassDescriptor)context2.getTrace().get((ReadOnlySlice)BindingContext.CLASS, (Object)containingClass);
            AnnotationDescriptor thisAnnotationDescriptor = (AnnotationDescriptor)context2.getTrace().get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)annotationEntry);
            if (containingClass != null && containingClassDescriptor != null && thisAnnotationDescriptor != null) {
                boolean bl;
                block15: {
                    Iterable $receiver$iv3 = (Iterable)containingClassDescriptor.getAnnotations();
                    if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv3) {
                            AnnotationDescriptor it6 = (AnnotationDescriptor)element$iv;
                            if (!Intrinsics.areEqual((Object)it6.getType(), (Object)thisAnnotationDescriptor.getType())) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    KtUserType ktUserType;
                    KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
                    Object object2 = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
                    if (!(object2 instanceof KtUserType)) {
                        object2 = null;
                    }
                    KtElement reportElement = (ktUserType = (KtUserType)object2) != null && (ktUserType = ktUserType.getReferenceExpression()) != null ? (KtElement)ktUserType : (KtElement)annotationEntry;
                    DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)context2.getTrace()), (Diagnostic)((Diagnostic)ErrorsAndroid.REDUNDANT_TYPE_PARCELER.on((PsiElement)reportElement, (Object)containingClass)), (DefaultErrorMessages.Extension)DefaultErrorMessagesAndroid.INSTANCE);
                }
            }
        }
    }

    private final void checkWriteWithUsage(ResolvedCall<?> resolvedCall, KtAnnotationEntry annotationEntry, CallCheckerContext context2, KtModifierListOwner element) {
        TypeProjection expectedType;
        Object v6;
        Function0 reportElement$;
        KotlinType actualType;
        block11: {
            KtModifierListOwner ktModifierListOwner = element;
            if (!(ktModifierListOwner instanceof KtTypeReference)) {
                ktModifierListOwner = null;
            }
            if ((KtTypeReference)ktModifierListOwner == null) {
                return;
            }
            KotlinType kotlinType = (KotlinType)context2.getTrace().get((ReadOnlySlice)BindingContext.TYPE, (Object)element);
            if (kotlinType == null || (kotlinType = TypeUtilsKt.replaceAnnotations((KotlinType)kotlinType, (Annotations)Annotations.Companion.getEMPTY())) == null) {
                return;
            }
            actualType = kotlinType;
            KotlinType kotlinType2 = (KotlinType)CollectionsKt.singleOrNull((Iterable)resolvedCall.getTypeArguments().values());
            if (kotlinType2 == null) {
                return;
            }
            KotlinType parcelerType = kotlinType2;
            ClassifierDescriptor classifierDescriptor = parcelerType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor parcelerClass = classDescriptor;
            PsiElement $receiver$iv = (PsiElement)element;
            KtClassOrObject containingClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)true);
            this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry, context2);
            reportElement$ = new Function0<KtElementImplStub<? extends StubElement<? extends KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>>>>>(annotationEntry){
                final /* synthetic */ KtAnnotationEntry $annotationEntry;

                @NotNull
                public final KtElementImplStub<? extends StubElement<? extends KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>>>> invoke() {
                    List list = this.$annotationEntry.getTypeArguments();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"annotationEntry.typeArguments");
                    KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.singleOrNull((List)list);
                    return ktTypeProjection != null ? (KtElementImplStub)ktTypeProjection : (KtElementImplStub)this.$annotationEntry;
                }
                {
                    this.$annotationEntry = ktAnnotationEntry;
                    super(0);
                }
            };
            if (Intrinsics.areEqual((Object)parcelerClass.getKind(), (Object)ClassKind.OBJECT) ^ true) {
                DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)context2.getTrace()), (Diagnostic)((Diagnostic)ErrorsAndroid.PARCELER_SHOULD_BE_OBJECT.on((PsiElement)reportElement$.invoke())), (DefaultErrorMessages.Extension)DefaultErrorMessagesAndroid.INSTANCE);
                return;
            }
            checkWriteWithUsage.2 fqName$ = checkWriteWithUsage.2.INSTANCE;
            SimpleType simpleType = parcelerClass.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType, (String)"parcelerClass.defaultType");
            Iterable $receiver$iv2 = TypeUtilsKt.supertypes((KotlinType)((KotlinType)simpleType));
            for (Object element$iv : $receiver$iv2) {
                KotlinType it = (KotlinType)element$iv;
                if (!Intrinsics.areEqual((Object)checkWriteWithUsage.2.INSTANCE.invoke(it), (Object)ParcelableResolveExtensionKt.getPARCELER_FQNAME())) continue;
                v6 = element$iv;
                break block11;
            }
            v6 = null;
        }
        KotlinType kotlinType = v6;
        if (kotlinType == null) {
            return;
        }
        KotlinType parcelerSuperType = kotlinType;
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull((List)parcelerSuperType.getArguments());
        if (typeProjection == null || (typeProjection = typeProjection.getType()) == null) {
            return;
        }
        TypeProjection typeProjection2 = expectedType = typeProjection;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeProjection2, (String)"expectedType");
        if (!TypeUtilsKt.isSubtypeOf((KotlinType)actualType, (KotlinType)typeProjection2)) {
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)context2.getTrace()), (Diagnostic)((Diagnostic)ErrorsAndroid.PARCELER_TYPE_INCOMPATIBLE.on((PsiElement)reportElement$.invoke(), (Object)expectedType, (Object)actualType)), (DefaultErrorMessages.Extension)DefaultErrorMessagesAndroid.INSTANCE);
        }
    }

    private final void checkIfTheContainingClassIsParcelize(KtClassOrObject containingClass, KtAnnotationEntry annotationEntry, CallCheckerContext context2) {
        ClassDescriptor containingClassDescriptor;
        if (containingClass != null && (containingClassDescriptor = (ClassDescriptor)context2.getTrace().get((ReadOnlySlice)BindingContext.CLASS, (Object)containingClass)) != null && !ParcelableResolveExtensionKt.isParcelize(containingClassDescriptor)) {
            KtUserType ktUserType;
            KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
            Object object = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
            if (!(object instanceof KtUserType)) {
                object = null;
            }
            KtElement reportElement = (ktUserType = (KtUserType)object) != null && (ktUserType = ktUserType.getReferenceExpression()) != null ? (KtElement)ktUserType : (KtElement)annotationEntry;
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)context2.getTrace()), (Diagnostic)((Diagnostic)ErrorsAndroid.CLASS_SHOULD_BE_PARCELIZE.on((PsiElement)reportElement, (Object)containingClass)), (DefaultErrorMessages.Extension)DefaultErrorMessagesAndroid.INSTANCE);
        }
    }

    static {
        Companion = new Companion(null);
        TYPE_PARCELER_FQNAME = new FqName(TypeParceler.class.getName());
        WRITE_WITH_FQNAME = new FqName(WriteWith.class.getName());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker$Companion;", "", "()V", "TYPE_PARCELER_FQNAME", "Lorg/jetbrains/kotlin/name/FqName;", "getTYPE_PARCELER_FQNAME", "()Lorg/jetbrains/kotlin/name/FqName;", "WRITE_WITH_FQNAME", "getWRITE_WITH_FQNAME", "android-extensions-compiler"})
    public static final class Companion {
        @NotNull
        public final FqName getTYPE_PARCELER_FQNAME() {
            return TYPE_PARCELER_FQNAME;
        }

        @NotNull
        public final FqName getWRITE_WITH_FQNAME() {
            return WRITE_WITH_FQNAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

