/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalJsCacheKt;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.TranslationResultValueExternalizer;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0086\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "", "value", "get", "sourceFile", "keys", "", "put", "", "newMetadata", "", "newBinaryAst", "newInlineData", "remove", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "kotlin-build-common"})
final class TranslationResultMap
extends BasicStringMap<TranslationResultValue> {
    private final FileToPathConverter pathConverter;

    @Override
    @NotNull
    protected String dumpValue(@NotNull TranslationResultValue value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return "Metadata: " + IncrementalJvmCacheKt.md5(value.getMetadata()) + ", Binary AST: " + IncrementalJvmCacheKt.md5(value.getBinaryAst()) + ", InlineData: " + IncrementalJvmCacheKt.md5(value.getInlineData());
    }

    public final void put(@NotNull File sourceFile, @NotNull byte[] newMetadata, @NotNull byte[] newBinaryAst, @NotNull byte[] newInlineData) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)newMetadata, (String)"newMetadata");
        Intrinsics.checkParameterIsNotNull((Object)newBinaryAst, (String)"newBinaryAst");
        Intrinsics.checkParameterIsNotNull((Object)newInlineData, (String)"newInlineData");
        this.getStorage().set(this.pathConverter.toPath(sourceFile), new TranslationResultValue(newMetadata, newBinaryAst, newInlineData));
    }

    @Nullable
    public final TranslationResultValue get(@NotNull File sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        return (TranslationResultValue)this.getStorage().get(this.pathConverter.toPath(sourceFile));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> keys() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getStorage().getKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = this.pathConverter.toFile((String)it);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    public final void remove(@NotNull File sourceFile, @NotNull ChangesCollector changesCollector) {
        Map<ClassId, ProtoData> protoMap;
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        String path = this.pathConverter.toPath(sourceFile);
        Object v = this.getStorage().get(path);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        byte[] protoBytes = ((TranslationResultValue)v).getMetadata();
        Map<ClassId, ProtoData> map = protoMap = IncrementalJsCacheKt.getProtoData(sourceFile, protoBytes);
        boolean bl = false;
        Iterator<Map.Entry<ClassId, ProtoData>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ClassId, ProtoData> entry;
            Map.Entry<ClassId, ProtoData> entry2 = entry = iterator.next();
            boolean bl2 = false;
            ProtoData protoData = entry2.getValue();
            ChangesCollector.collectProtoChanges$default(changesCollector, protoData, null, false, 4, null);
        }
        this.getStorage().remove(path);
    }

    public TranslationResultMap(@NotNull File storageFile, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        Intrinsics.checkParameterIsNotNull((Object)pathConverter, (String)"pathConverter");
        super(storageFile, TranslationResultValueExternalizer.INSTANCE);
        this.pathConverter = pathConverter;
    }
}

