/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class HierarchicalMethodSignatureImpl
extends HierarchicalMethodSignature {
    private List<HierarchicalMethodSignature> mySupers;
    private List<HierarchicalMethodSignature> myInaccessibleSupers;

    public HierarchicalMethodSignatureImpl(@NotNull MethodSignatureBackedByPsiMethod signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/com/intellij/psi/impl/source/HierarchicalMethodSignatureImpl", "<init>"));
        }
        super(signature);
    }

    public void addSuperSignature(@NotNull HierarchicalMethodSignature superSignatureHierarchical) {
        if (superSignatureHierarchical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignatureHierarchical", "org/jetbrains/kotlin/com/intellij/psi/impl/source/HierarchicalMethodSignatureImpl", "addSuperSignature"));
        }
        PsiMethod superMethod = superSignatureHierarchical.getMethod();
        PsiMethod method = this.getMethod();
        if (PsiUtil.isAccessible(method.getProject(), superMethod, method, null)) {
            if (this.mySupers == null) {
                this.mySupers = new SmartList<HierarchicalMethodSignature>();
            }
            this.mySupers.add(superSignatureHierarchical);
        } else {
            if (this.myInaccessibleSupers == null) {
                this.myInaccessibleSupers = new SmartList<HierarchicalMethodSignature>();
            }
            this.myInaccessibleSupers.add(superSignatureHierarchical);
        }
    }

    @Override
    @NotNull
    public List<HierarchicalMethodSignature> getSuperSignatures() {
        List<Object> list2 = this.mySupers == null ? Collections.emptyList() : this.mySupers;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/HierarchicalMethodSignatureImpl", "getSuperSignatures"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<HierarchicalMethodSignature> getInaccessibleSuperSignatures() {
        List<HierarchicalMethodSignature> list2 = this.myInaccessibleSupers == null ? super.getInaccessibleSuperSignatures() : this.myInaccessibleSupers;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/HierarchicalMethodSignatureImpl", "getInaccessibleSuperSignatures"));
        }
        return list2;
    }
}

