/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.job;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.jodconverter.job.AbstractSourceDocumentSpecs;
import org.jodconverter.job.DocumentSpecsIOException;
import org.jodconverter.job.SourceDocumentSpecs;
import org.jodconverter.office.TemporaryFileMaker;

class SourceDocumentSpecsFromInputStream
extends AbstractSourceDocumentSpecs
implements SourceDocumentSpecs {
    private final InputStream inputStream;
    private final boolean closeStream;
    private final TemporaryFileMaker fileMaker;

    public SourceDocumentSpecsFromInputStream(InputStream inputStream, TemporaryFileMaker fileMaker, boolean closeStream) {
        super(fileMaker.makeTemporaryFile());
        Validate.notNull((Object)inputStream, (String)"The inputStream is null", (Object[])new Object[0]);
        this.inputStream = inputStream;
        this.closeStream = closeStream;
        this.fileMaker = fileMaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFile() {
        File file;
        File tempFile = Optional.ofNullable(this.getFormat()).map(format -> this.fileMaker.makeTemporaryFile(format.getExtension())).orElse(super.getFile());
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        outputStream.getChannel().lock();
        try {
            IOUtils.copy((InputStream)this.inputStream, (OutputStream)outputStream);
            file = tempFile;
        }
        catch (Throwable throwable) {
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new DocumentSpecsIOException("Could not write stream to file " + tempFile, ex);
            }
        }
        outputStream.close();
        return file;
    }

    @Override
    public void onConsumed(File tempFile) {
        FileUtils.deleteQuietly((File)tempFile);
        if (this.closeStream) {
            try {
                this.inputStream.close();
            }
            catch (IOException ex) {
                throw new DocumentSpecsIOException("Could not close input stream", ex);
            }
        }
    }
}

