/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.job;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;
import org.jodconverter.job.AbstractTargetDocumentSpecs;
import org.jodconverter.job.DocumentSpecsIOException;
import org.jodconverter.job.TargetDocumentSpecs;
import org.jodconverter.office.TemporaryFileMaker;

class TargetDocumentSpecsFromOutputStream
extends AbstractTargetDocumentSpecs
implements TargetDocumentSpecs {
    private final OutputStream outputStream;
    private final boolean closeStream;
    private final TemporaryFileMaker fileMaker;

    public TargetDocumentSpecsFromOutputStream(OutputStream outputStream, TemporaryFileMaker fileMaker, boolean closeStream) {
        super(fileMaker.makeTemporaryFile());
        Validate.notNull((Object)outputStream, (String)"The outputStream is null", (Object[])new Object[0]);
        this.outputStream = outputStream;
        this.closeStream = closeStream;
        this.fileMaker = fileMaker;
    }

    @Override
    public File getFile() {
        return Optional.ofNullable(this.getFormat()).map(format -> this.fileMaker.makeTemporaryFile(format.getExtension())).orElse(super.getFile());
    }

    @Override
    public void onComplete(File tempFile) {
        try {
            FileUtils.copyFile((File)tempFile, (OutputStream)this.outputStream);
            if (this.closeStream) {
                this.outputStream.close();
            }
        }
        catch (IOException ex) {
            throw new DocumentSpecsIOException("Could not write file '" + tempFile + "' to stream", ex);
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    @Override
    public void onFailure(File tempFile, Exception exception) {
        FileUtils.deleteQuietly((File)tempFile);
    }
}

