/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.task;

import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;
import org.apache.commons.lang3.Validate;
import org.jodconverter.document.DocumentFamily;
import org.jodconverter.office.OfficeException;

final class LocalOfficeTaskUtils {
    public static DocumentFamily getDocumentFamily(XComponent document) throws OfficeException {
        Validate.notNull((Object)document, (String)"The document is null", (Object[])new Object[0]);
        XServiceInfo serviceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)document);
        if (serviceInfo.supportsService("com.sun.star.text.GenericTextDocument")) {
            return DocumentFamily.TEXT;
        }
        if (serviceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            return DocumentFamily.SPREADSHEET;
        }
        if (serviceInfo.supportsService("com.sun.star.presentation.PresentationDocument")) {
            return DocumentFamily.PRESENTATION;
        }
        if (serviceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            return DocumentFamily.DRAWING;
        }
        throw new OfficeException("Document of unknown family: " + serviceInfo.getImplementationName());
    }

    private LocalOfficeTaskUtils() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

