/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CRAMMD5BindRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequest;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequestProperties;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DisconnectHandler;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.GSSAPIBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.ldaptive.AddRequest;
import org.ldaptive.BindRequest;
import org.ldaptive.CompareRequest;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyDnRequest;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchReference;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.async.AsyncRequest;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.extended.ExtendedResponse;
import org.ldaptive.extended.ExtendedResponseFactory;
import org.ldaptive.extended.UnsolicitedNotificationListener;
import org.ldaptive.intermediate.IntermediateResponse;
import org.ldaptive.intermediate.IntermediateResponseFactory;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderUtils;
import org.ldaptive.provider.SearchItem;
import org.ldaptive.provider.SearchIterator;
import org.ldaptive.provider.SearchListener;
import org.ldaptive.provider.unboundid.UnboundIDProviderConfig;
import org.ldaptive.provider.unboundid.UnboundIDSaslUtils;
import org.ldaptive.provider.unboundid.UnboundIDUtils;
import org.ldaptive.sasl.SaslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnboundIDConnection
implements ProviderConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LDAPConnection connection;
    private final UnboundIDProviderConfig config;
    private final AggregateUnsolicitedNotificationHandler notificationHandler = new AggregateUnsolicitedNotificationHandler();
    private final AggregateDisconnectHandler disconnectHandler = new AggregateDisconnectHandler();

    public UnboundIDConnection(LDAPConnection lc, UnboundIDProviderConfig pc) {
        this.connection = lc;
        this.config = pc;
        LDAPConnectionOptions options = this.connection.getConnectionOptions();
        if (options.getUnsolicitedNotificationHandler() == null) {
            options.setUnsolicitedNotificationHandler((UnsolicitedNotificationHandler)this.notificationHandler);
        }
        if (options.getDisconnectHandler() == null) {
            options.setDisconnectHandler((DisconnectHandler)this.disconnectHandler);
        }
    }

    public LDAPConnection getLdapConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(RequestControl[] controls) throws LdapException {
        if (this.connection != null) {
            try {
                this.connection.close((Control[])this.config.getControlProcessor().processRequestControls(controls));
            }
            finally {
                this.connection = null;
            }
        }
    }

    public Response<Void> bind(BindRequest request) throws LdapException {
        Response<Void> response = request.getSaslConfig() != null ? this.saslBind(request) : (request.getDn() == null && request.getCredential() == null ? this.anonymousBind(request) : this.simpleBind(request));
        return response;
    }

    protected Response<Void> anonymousBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            SimpleBindRequest sbr = request.getControls() != null ? new SimpleBindRequest("", new byte[0], (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) : new SimpleBindRequest();
            sbr.setFollowReferrals(Boolean.valueOf(request.getFollowReferrals()));
            BindResult result = this.connection.bind((com.unboundid.ldap.sdk.BindRequest)sbr);
            response = this.createResponse((Request)request, null, (LDAPResult)result);
        }
        catch (LDAPException e) {
            this.processLDAPException((Request)request, e);
        }
        return response;
    }

    protected Response<Void> simpleBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            SimpleBindRequest sbr = request.getControls() != null ? new SimpleBindRequest(new DN(request.getDn()), request.getCredential().getBytes(), (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) : new SimpleBindRequest(request.getDn(), request.getCredential().getBytes());
            sbr.setFollowReferrals(Boolean.valueOf(request.getFollowReferrals()));
            BindResult result = this.connection.bind((com.unboundid.ldap.sdk.BindRequest)sbr);
            response = this.createResponse((Request)request, null, (LDAPResult)result);
        }
        catch (LDAPException e) {
            this.processLDAPException((Request)request, e);
        }
        return response;
    }

    protected Response<Void> saslBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            EXTERNALBindRequest sbr;
            SaslConfig sc = request.getSaslConfig();
            switch (sc.getMechanism()) {
                case EXTERNAL: {
                    sbr = new EXTERNALBindRequest(sc.getAuthorizationId(), (Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
                    break;
                }
                case DIGEST_MD5: {
                    DIGESTMD5BindRequestProperties digestMd5Props = UnboundIDSaslUtils.createDigestMd5Properties(request.getDn(), request.getCredential(), request.getSaslConfig());
                    sbr = new DIGESTMD5BindRequest(digestMd5Props, (Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
                    break;
                }
                case CRAM_MD5: {
                    sbr = new CRAMMD5BindRequest(request.getDn(), request.getCredential() != null ? request.getCredential().getBytes() : null, (Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
                    break;
                }
                case GSSAPI: {
                    GSSAPIBindRequestProperties props = UnboundIDSaslUtils.createGssApiProperties(request.getDn(), request.getCredential(), request.getSaslConfig());
                    sbr = new GSSAPIBindRequest(props, (Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown SASL authentication mechanism: " + sc.getMechanism());
                }
            }
            sbr.setFollowReferrals(Boolean.valueOf(request.getFollowReferrals()));
            BindResult result = this.connection.bind((com.unboundid.ldap.sdk.BindRequest)sbr);
            response = this.createResponse((Request)request, null, (LDAPResult)result);
        }
        catch (LDAPException e) {
            this.processLDAPException((Request)request, e);
        }
        return response;
    }

    public Response<Void> add(AddRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            UnboundIDUtils util = new UnboundIDUtils();
            com.unboundid.ldap.sdk.AddRequest ar = new com.unboundid.ldap.sdk.AddRequest(new DN(request.getDn()), util.fromLdapAttributes(request.getLdapAttributes()), (Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            ar.setFollowReferrals(Boolean.valueOf(request.getFollowReferrals()));
            LDAPResult result = this.connection.add(ar);
            response = this.createResponse((Request)request, null, result);
        }
        catch (LDAPException e) {
            this.processLDAPException((Request)request, e);
        }
        return response;
    }

    public Response<Boolean> compare(CompareRequest request) throws LdapException {
        Response<Boolean> response = null;
        try {
            com.unboundid.ldap.sdk.CompareRequest cr = request.getAttribute().isBinary() ? new com.unboundid.ldap.sdk.CompareRequest(new DN(request.getDn()), request.getAttribute().getName(), request.getAttribute().getBinaryValue(), (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) : new com.unboundid.ldap.sdk.CompareRequest(new DN(request.getDn()), request.getAttribute().getName(), request.getAttribute().getStringValue(), (Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            cr.setFollowReferrals(Boolean.valueOf(request.getFollowReferrals()));
            CompareResult result = this.connection.compare(cr);
            response = this.createResponse((Request)request, result.compareMatched(), (LDAPResult)result);
        }
        catch (LDAPException e) {
            this.processLDAPException((Request)request, e);
        }
        return response;
    }

    public Response<Void> delete(DeleteRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            com.unboundid.ldap.sdk.DeleteRequest dr = new com.unboundid.ldap.sdk.DeleteRequest(new DN(request.getDn()), (Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            dr.setFollowReferrals(Boolean.valueOf(request.getFollowReferrals()));
            LDAPResult result = this.connection.delete(dr);
            response = this.createResponse((Request)request, null, result);
        }
        catch (LDAPException e) {
            this.processLDAPException((Request)request, e);
        }
        return response;
    }

    public Response<Void> modify(ModifyRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            UnboundIDUtils bu = new UnboundIDUtils();
            com.unboundid.ldap.sdk.ModifyRequest mr = new com.unboundid.ldap.sdk.ModifyRequest(new DN(request.getDn()), bu.fromAttributeModification(request.getAttributeModifications()), (Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            mr.setFollowReferrals(Boolean.valueOf(request.getFollowReferrals()));
            LDAPResult result = this.connection.modify(mr);
            response = this.createResponse((Request)request, null, result);
        }
        catch (LDAPException e) {
            this.processLDAPException((Request)request, e);
        }
        return response;
    }

    public Response<Void> modifyDn(ModifyDnRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            DN dn = new DN(request.getDn());
            DN newDn = new DN(request.getNewDn());
            ModifyDNRequest mdr = new ModifyDNRequest(dn, newDn.getRDN(), request.getDeleteOldRDn(), newDn.getParent(), (Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            mdr.setFollowReferrals(Boolean.valueOf(request.getFollowReferrals()));
            LDAPResult result = this.connection.modifyDN(mdr);
            response = this.createResponse((Request)request, null, result);
        }
        catch (LDAPException e) {
            this.processLDAPException((Request)request, e);
        }
        return response;
    }

    public SearchIterator search(SearchRequest request) throws LdapException {
        UnboundIDSearchIterator i = new UnboundIDSearchIterator(request);
        i.initialize();
        return i;
    }

    public void searchAsync(SearchRequest request, SearchListener listener) throws LdapException {
        UnboundIDAsyncSearchListener l = new UnboundIDAsyncSearchListener(request, listener);
        l.initialize();
    }

    public void abandon(int messageId, RequestControl[] controls) throws LdapException {
        throw new UnsupportedOperationException("Abandons via messageId not supported, use AsyncRequest instead");
    }

    public Response<?> extendedOperation(org.ldaptive.extended.ExtendedRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            byte[] requestBerValue = request.encode();
            ExtendedRequest er = requestBerValue == null ? new ExtendedRequest(request.getOID(), (Control[])this.config.getControlProcessor().processRequestControls((RequestControl[])request.getControls())) : new ExtendedRequest(request.getOID(), new ASN1OctetString(requestBerValue), (Control[])this.config.getControlProcessor().processRequestControls((RequestControl[])request.getControls()));
            er.setFollowReferrals(Boolean.valueOf(request.getFollowReferrals()));
            ExtendedResult result = this.connection.processExtendedOperation(er);
            byte[] responseBerValue = result.getValue() != null ? result.getValue().getValue() : null;
            ExtendedResponse extRes = ExtendedResponseFactory.createExtendedResponse((String)request.getOID(), (String)result.getOID(), (byte[])responseBerValue);
            response = this.createResponse((Request)request, extRes.getValue(), (LDAPResult)result);
        }
        catch (LDAPException e) {
            this.processLDAPException((Request)request, e);
        }
        return response;
    }

    public void addUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        this.notificationHandler.addUnsolicitedNotificationListener(listener);
    }

    public void removeUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        this.notificationHandler.removeUnsolicitedNotificationListener(listener);
    }

    protected <T> Response<T> createResponse(Request request, T result, LDAPResult ldapResult) {
        return new Response(result, ResultCode.valueOf((int)ldapResult.getResultCode().intValue()), ldapResult.getDiagnosticMessage(), ldapResult.getMatchedDN(), this.config.getControlProcessor().processResponseControls((Object[])ldapResult.getResponseControls()), ldapResult.getReferralURLs(), ldapResult.getMessageID());
    }

    protected void processLDAPException(Request request, LDAPException e) throws LdapException {
        ProviderUtils.throwOperationException((ResultCode[])this.config.getOperationExceptionResultCodes(), (Exception)((Object)e), (int)e.getResultCode().intValue(), (String)e.getMatchedDN(), (ResponseControl[])this.config.getControlProcessor().processResponseControls((Object[])e.getResponseControls()), (String[])e.getReferralURLs(), (boolean)true);
    }

    protected class AggregateDisconnectHandler
    implements DisconnectHandler {
        private final Queue<DisconnectHandler> handlers = new ConcurrentLinkedQueue<DisconnectHandler>();

        protected AggregateDisconnectHandler() {
        }

        public void addDisconnectHandler(DisconnectHandler handler) {
            this.handlers.add(handler);
        }

        public void removeDisconnectHandler(DisconnectHandler handler) {
            this.handlers.remove(handler);
        }

        public void handleDisconnect(LDAPConnection ldapConnection, String host, int port, DisconnectType disconnectType, String message, Throwable throwable) {
            UnboundIDConnection.this.logger.debug("Disconnection received: {}", (Object)disconnectType);
            for (DisconnectHandler handler : this.handlers) {
                handler.handleDisconnect(ldapConnection, host, port, disconnectType, message, throwable);
            }
        }
    }

    protected class AggregateUnsolicitedNotificationHandler
    implements UnsolicitedNotificationHandler {
        private final Queue<UnsolicitedNotificationListener> listeners = new ConcurrentLinkedQueue<UnsolicitedNotificationListener>();

        protected AggregateUnsolicitedNotificationHandler() {
        }

        public void addUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
            this.listeners.add(listener);
        }

        public void removeUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
            this.listeners.remove(listener);
        }

        public void handleUnsolicitedNotification(LDAPConnection ldapConnection, ExtendedResult extendedResult) {
            UnboundIDConnection.this.logger.debug("Unsolicited notification received: {}", (Object)extendedResult);
            Response<Object> response = UnboundIDConnection.this.createResponse(null, null, (LDAPResult)extendedResult);
            for (UnsolicitedNotificationListener listener : this.listeners) {
                listener.notificationReceived(extendedResult.getOID(), response);
            }
        }
    }

    protected class UnboundIDAsyncRequest
    implements AsyncRequest {
        private final AsyncRequestID requestID;
        private final Request request;

        public UnboundIDAsyncRequest(AsyncRequestID id, Request r) {
            this.requestID = id;
            this.request = r;
        }

        public int getMessageId() {
            return this.requestID.getMessageID();
        }

        public void abandon() throws LdapException {
            try {
                UnboundIDConnection.this.connection.abandon(this.requestID);
            }
            catch (LDAPException e) {
                UnboundIDConnection.this.processLDAPException(this.request, e);
            }
        }

        public void abandon(RequestControl[] controls) throws LdapException {
            try {
                UnboundIDConnection.this.connection.abandon(this.requestID, (Control[])UnboundIDConnection.this.config.getControlProcessor().processRequestControls((RequestControl[])this.request.getControls()));
            }
            catch (LDAPException e) {
                UnboundIDConnection.this.processLDAPException(this.request, e);
            }
        }
    }

    protected abstract class AbstractUnboundIDSearch {
        protected final SearchRequest request;
        protected final UnboundIDUtils util;

        public AbstractUnboundIDSearch(SearchRequest sr) {
            this.request = sr;
            this.util = new UnboundIDUtils(this.request.getSortBehavior());
            this.util.setBinaryAttributes(this.request.getBinaryAttributes());
        }

        protected com.unboundid.ldap.sdk.SearchRequest getSearchRequest(SearchRequest sr, SearchResultListener srListener, IntermediateResponseListener irListener) throws LDAPSearchException {
            try {
                com.unboundid.ldap.sdk.SearchRequest req = new com.unboundid.ldap.sdk.SearchRequest(srListener, sr.getBaseDn(), this.getSearchScope(sr.getSearchScope()), this.getDereferencePolicy(sr.getDerefAliases()), (int)sr.getSizeLimit(), (int)sr.getTimeLimit(), sr.getTypesOnly(), sr.getSearchFilter() != null ? sr.getSearchFilter().format() : null, sr.getReturnAttributes());
                req.setFollowReferrals(Boolean.valueOf(sr.getFollowReferrals()));
                if (irListener != null) {
                    req.setIntermediateResponseListener(irListener);
                }
                return req;
            }
            catch (LDAPException e) {
                throw new LDAPSearchException(e);
            }
        }

        protected com.unboundid.ldap.sdk.SearchScope getSearchScope(SearchScope ss) {
            com.unboundid.ldap.sdk.SearchScope scope = null;
            if (ss == SearchScope.OBJECT) {
                scope = com.unboundid.ldap.sdk.SearchScope.BASE;
            } else if (ss == SearchScope.ONELEVEL) {
                scope = com.unboundid.ldap.sdk.SearchScope.ONE;
            } else if (ss == SearchScope.SUBTREE) {
                scope = com.unboundid.ldap.sdk.SearchScope.SUB;
            }
            return scope;
        }

        protected DereferencePolicy getDereferencePolicy(DerefAliases deref) {
            DereferencePolicy policy = DereferencePolicy.NEVER;
            if (deref == DerefAliases.ALWAYS) {
                policy = DereferencePolicy.ALWAYS;
            } else if (deref == DerefAliases.FINDING) {
                policy = DereferencePolicy.FINDING;
            } else if (deref == DerefAliases.NEVER) {
                policy = DereferencePolicy.NEVER;
            } else if (deref == DerefAliases.SEARCHING) {
                policy = DereferencePolicy.SEARCHING;
            }
            return policy;
        }

        protected ResultCode ignoreSearchException(ResultCode[] ignoreResultCodes, LDAPException e) {
            ResultCode ignore = null;
            if (ignoreResultCodes != null && ignoreResultCodes.length > 0) {
                for (ResultCode rc : ignoreResultCodes) {
                    if (e.getResultCode().intValue() != rc.value()) continue;
                    UnboundIDConnection.this.logger.debug("Ignoring ldap exception", (Throwable)e);
                    ignore = rc;
                    break;
                }
            }
            return ignore;
        }

        protected SearchItem processSearchResultEntry(SearchResultEntry entry) {
            UnboundIDConnection.this.logger.trace("reading search entry: {}", (Object)entry);
            ResponseControl[] respControls = null;
            if (entry.getControls() != null && entry.getControls().length > 0) {
                respControls = UnboundIDConnection.this.config.getControlProcessor().processResponseControls((Object[])entry.getControls());
            }
            SearchEntry se = this.util.toSearchEntry((Entry)entry, respControls, entry.getMessageID());
            return new SearchItem(se);
        }

        protected SearchItem processSearchResultReference(SearchResultReference ref) {
            UnboundIDConnection.this.logger.trace("reading search reference: {}", (Object)ref);
            ResponseControl[] respControls = null;
            if (ref.getControls() != null && ref.getControls().length > 0) {
                respControls = UnboundIDConnection.this.config.getControlProcessor().processResponseControls((Object[])ref.getControls());
            }
            SearchReference sr = new SearchReference(ref.getMessageID(), respControls, ref.getReferralURLs());
            return new SearchItem(sr);
        }

        protected SearchItem processIntermediateResponse(com.unboundid.ldap.sdk.IntermediateResponse res) {
            UnboundIDConnection.this.logger.trace("reading intermediate response: {}", (Object)res);
            ResponseControl[] respControls = null;
            if (res.getControls() != null && res.getControls().length > 0) {
                respControls = UnboundIDConnection.this.config.getControlProcessor().processResponseControls((Object[])res.getControls());
            }
            IntermediateResponse ir = IntermediateResponseFactory.createIntermediateResponse((String)res.getOID(), (byte[])res.getValue().getValue(), respControls, (int)res.getMessageID());
            return new SearchItem(ir);
        }
    }

    protected class UnboundIDAsyncSearchListener
    extends AbstractUnboundIDSearch
    implements AsyncSearchResultListener,
    IntermediateResponseListener {
        private final SearchListener listener;
        private AsyncRequestID requestID;
        private final DisconnectHandler handler;

        public UnboundIDAsyncSearchListener(SearchRequest sr, SearchListener sl) {
            super(sr);
            this.listener = sl;
            this.handler = new DisconnectHandler(){

                public void handleDisconnect(LDAPConnection ldapConnection, String host, int port, DisconnectType disconnectType, String message, Throwable throwable) {
                    UnboundIDAsyncSearchListener.this.listener.exceptionReceived(new Exception(message, throwable));
                    UnboundIDConnection.this.disconnectHandler.removeDisconnectHandler(this);
                }
            };
        }

        public AsyncRequestID getRequestID() {
            return this.requestID;
        }

        public void initialize() throws LdapException {
            this.search(UnboundIDConnection.this.connection, this.request);
        }

        protected void search(LDAPConnection conn, SearchRequest sr) throws LdapException {
            try {
                com.unboundid.ldap.sdk.SearchRequest unboundIdSr = this.getSearchRequest(sr, (SearchResultListener)this, this);
                Control[] c = (Control[])UnboundIDConnection.this.config.getControlProcessor().processRequestControls(sr.getControls());
                unboundIdSr.addControls(c);
                UnboundIDConnection.this.logger.debug("performing search: {}", (Object)unboundIdSr);
                this.requestID = conn.asyncSearch(unboundIdSr);
                UnboundIDConnection.this.disconnectHandler.addDisconnectHandler(this.handler);
                this.listener.asyncRequestReceived((AsyncRequest)new UnboundIDAsyncRequest(this.requestID, (Request)sr));
            }
            catch (LDAPSearchException e) {
                ResultCode rc = this.ignoreSearchException(UnboundIDConnection.this.config.getSearchIgnoreResultCodes(), (LDAPException)((Object)e));
                if (rc == null) {
                    UnboundIDConnection.this.processLDAPException((Request)sr, (LDAPException)((Object)e));
                }
            }
            catch (LDAPException e) {
                UnboundIDConnection.this.processLDAPException((Request)sr, e);
            }
        }

        public void searchEntryReturned(SearchResultEntry entry) {
            this.listener.searchItemReceived(this.processSearchResultEntry(entry));
        }

        public void searchReferenceReturned(SearchResultReference ref) {
            this.listener.searchItemReceived(this.processSearchResultReference(ref));
        }

        public void intermediateResponseReturned(com.unboundid.ldap.sdk.IntermediateResponse res) {
            this.listener.searchItemReceived(this.processIntermediateResponse(res));
        }

        public void searchResultReceived(AsyncRequestID id, SearchResult res) {
            UnboundIDConnection.this.logger.trace("reading result: {}", (Object)res);
            UnboundIDConnection.this.disconnectHandler.removeDisconnectHandler(this.handler);
            Response<Object> response = UnboundIDConnection.this.createResponse((Request)this.request, null, (LDAPResult)res);
            this.listener.responseReceived(response);
        }
    }

    protected class UnboundIDSearchIterator
    extends AbstractUnboundIDSearch
    implements SearchIterator {
        private Response<Void> response;
        private SearchResultIterator resultIterator;

        public UnboundIDSearchIterator(SearchRequest sr) {
            super(sr);
        }

        public void initialize() throws LdapException {
            this.resultIterator = this.search(UnboundIDConnection.this.connection, this.request);
        }

        protected SearchResultIterator search(LDAPConnection conn, SearchRequest sr) throws LdapException {
            SearchResultIterator i = new SearchResultIterator();
            try {
                com.unboundid.ldap.sdk.SearchRequest unboundIdSr = this.getSearchRequest(sr, i, i);
                Control[] c = (Control[])UnboundIDConnection.this.config.getControlProcessor().processRequestControls(sr.getControls());
                unboundIdSr.addControls(c);
                UnboundIDConnection.this.logger.debug("performing search: {}", (Object)unboundIdSr);
                SearchResult result = conn.search(unboundIdSr);
                this.response = UnboundIDConnection.this.createResponse((Request)this.request, null, (LDAPResult)result);
                UnboundIDConnection.this.logger.debug("created response: {}", this.response);
            }
            catch (LDAPSearchException e) {
                ResultCode rc = this.ignoreSearchException(UnboundIDConnection.this.config.getSearchIgnoreResultCodes(), (LDAPException)((Object)e));
                if (rc == null) {
                    UnboundIDConnection.this.processLDAPException((Request)sr, (LDAPException)((Object)e));
                }
                this.response = UnboundIDConnection.this.createResponse((Request)this.request, null, (LDAPResult)new SearchResult(-1, e.getResultCode(), e.getDiagnosticMessage(), e.getMatchedDN(), e.getReferralURLs(), e.getEntryCount(), e.getReferenceCount(), e.getResponseControls()));
                UnboundIDConnection.this.logger.debug("created response: {}", this.response);
            }
            catch (LDAPException e) {
                UnboundIDConnection.this.processLDAPException((Request)sr, e);
            }
            return i;
        }

        public boolean hasNext() throws LdapException {
            return this.resultIterator != null && this.resultIterator.hasNext();
        }

        public SearchItem next() throws LdapException {
            return this.resultIterator.next();
        }

        public Response<Void> getResponse() {
            return this.response;
        }

        public void close() throws LdapException {
        }

        protected class SearchResultIterator
        implements SearchResultListener,
        IntermediateResponseListener {
            protected final Queue<SearchItem> queue = new ArrayDeque<SearchItem>();

            protected SearchResultIterator() {
            }

            public SearchItem next() {
                return this.queue.poll();
            }

            public boolean hasNext() {
                return !this.queue.isEmpty();
            }

            public void searchEntryReturned(SearchResultEntry entry) {
                this.queue.add(UnboundIDSearchIterator.this.processSearchResultEntry(entry));
            }

            public void searchReferenceReturned(SearchResultReference ref) {
                this.queue.add(UnboundIDSearchIterator.this.processSearchResultReference(ref));
            }

            public void intermediateResponseReturned(com.unboundid.ldap.sdk.IntermediateResponse res) {
                this.queue.add(UnboundIDSearchIterator.this.processIntermediateResponse(res));
            }
        }
    }
}

